/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.config;

import cc.redpen.config.SymbolType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class Symbol
implements Serializable {
    private static final long serialVersionUID = 3826499136262740992L;
    private final SymbolType name;
    private final char value;
    private final char[] invalidChars;
    private final boolean needBeforeSpace;
    private final boolean needAfterSpace;

    public Symbol(SymbolType symbolType, char charValue) {
        this(symbolType, charValue, "", false, false);
    }

    public Symbol(SymbolType symbolType, char charValue, String invalidCharsStr) {
        this(symbolType, charValue, invalidCharsStr, false, false);
    }

    public Symbol(SymbolType symbolType, char charValue, String invalidCharsStr, boolean haveBeforeSpace, boolean haveAfterSpace) {
        this.name = symbolType;
        this.value = charValue;
        this.invalidChars = invalidCharsStr.toCharArray();
        this.needBeforeSpace = haveBeforeSpace;
        this.needAfterSpace = haveAfterSpace;
    }

    public SymbolType getType() {
        return this.name;
    }

    public char getValue() {
        return this.value;
    }

    public char[] getInvalidChars() {
        return this.invalidChars;
    }

    public boolean isNeedBeforeSpace() {
        return this.needBeforeSpace;
    }

    public boolean isNeedAfterSpace() {
        return this.needAfterSpace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Symbol that = (Symbol)o;
        return Objects.equals((Object)this.name, (Object)that.name) && Objects.equals(Character.valueOf(this.value), Character.valueOf(that.value)) && Arrays.equals(this.invalidChars, that.invalidChars) && Objects.equals(this.needBeforeSpace, that.needBeforeSpace) && Objects.equals(this.needAfterSpace, that.needAfterSpace);
    }

    public int hashCode() {
        return Objects.hashCode((Object)this.name);
    }

    public String toString() {
        return "Symbol{name=" + (Object)((Object)this.name) + ", value=" + this.value + ", invalidChars=" + Arrays.toString(this.invalidChars) + ", needBeforeSpace=" + this.needBeforeSpace + ", needAfterSpace=" + this.needAfterSpace + '}';
    }
}

