/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.config;

import cc.redpen.config.Symbol;
import cc.redpen.config.SymbolType;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolTable
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1612920745151501631L;
    private Map<SymbolType, Symbol> symbolDictionary = new LinkedHashMap<SymbolType, Symbol>();
    private Map<Character, Symbol> valueDictionary = new LinkedHashMap<Character, Symbol>();
    private String variant;
    private String lang;
    private static final Logger LOG = LoggerFactory.getLogger(SymbolTable.class);
    private static final Map<SymbolType, Symbol> DEFAULT_SYMBOLS = SymbolTable.initializeSymbols(new Symbol(SymbolType.SPACE, ' ', ""), new Symbol(SymbolType.EXCLAMATION_MARK, '!', "\uff01"), new Symbol(SymbolType.NUMBER_SIGN, '#', "\uff03"), new Symbol(SymbolType.DOLLAR_SIGN, '$', "\uff04"), new Symbol(SymbolType.PERCENT_SIGN, '%', "\uff05"), new Symbol(SymbolType.QUESTION_MARK, '?', "\uff1f"), new Symbol(SymbolType.AMPERSAND, '&', "\uff06"), new Symbol(SymbolType.LEFT_PARENTHESIS, '(', "\uff08", true, false), new Symbol(SymbolType.RIGHT_PARENTHESIS, ')', "\uff09", false, true), new Symbol(SymbolType.ASTERISK, '*', "\uff0a"), new Symbol(SymbolType.COMMA, ',', "\uff0c\u3001", false, true), new Symbol(SymbolType.FULL_STOP, '.', "\uff0e\u3002"), new Symbol(SymbolType.PLUS_SIGN, '+', "\uff0b"), new Symbol(SymbolType.HYPHEN_SIGN, '-', "\u30fc"), new Symbol(SymbolType.SLASH, '/', "\uff0f"), new Symbol(SymbolType.COLON, ':', "\uff1a"), new Symbol(SymbolType.SEMICOLON, ';', "\uff1b"), new Symbol(SymbolType.LESS_THAN_SIGN, '<', "\uff1c"), new Symbol(SymbolType.EQUAL_SIGN, '=', "\uff1d"), new Symbol(SymbolType.GREATER_THAN_SIGN, '>', "\uff1e"), new Symbol(SymbolType.AT_MARK, '@', "\uff20"), new Symbol(SymbolType.LEFT_SQUARE_BRACKET, '[', "", true, false), new Symbol(SymbolType.RIGHT_SQUARE_BRACKET, ']', "", false, true), new Symbol(SymbolType.BACKSLASH, '\\', ""), new Symbol(SymbolType.CIRCUMFLEX_ACCENT, '^', ""), new Symbol(SymbolType.LOW_LINE, '_', ""), new Symbol(SymbolType.LEFT_CURLY_BRACKET, '{', "\uff5b", true, false), new Symbol(SymbolType.RIGHT_CURLY_BRACKET, '}', "\uff5d", false, true), new Symbol(SymbolType.VERTICAL_BAR, '|', "\uff5c"), new Symbol(SymbolType.TILDE, '~', "\u301c"), new Symbol(SymbolType.LEFT_SINGLE_QUOTATION_MARK, '\'', ""), new Symbol(SymbolType.RIGHT_SINGLE_QUOTATION_MARK, '\'', ""), new Symbol(SymbolType.LEFT_DOUBLE_QUOTATION_MARK, '\"', "\u00ab"), new Symbol(SymbolType.RIGHT_DOUBLE_QUOTATION_MARK, '\"', "\u00bb"), new Symbol(SymbolType.DIGIT_ZERO, '0', ""), new Symbol(SymbolType.DIGIT_ONE, '1', ""), new Symbol(SymbolType.DIGIT_TWO, '2', ""), new Symbol(SymbolType.DIGIT_THREE, '3', ""), new Symbol(SymbolType.DIGIT_FOUR, '4', ""), new Symbol(SymbolType.DIGIT_FIVE, '5', ""), new Symbol(SymbolType.DIGIT_SIX, '6', ""), new Symbol(SymbolType.DIGIT_SEVEN, '7', ""), new Symbol(SymbolType.DIGIT_EIGHT, '8', ""), new Symbol(SymbolType.DIGIT_NINE, '9', ""));
    private static final Map<SymbolType, Symbol> RUSSIAN_SYMBOLS = new LinkedHashMap<SymbolType, Symbol>(DEFAULT_SYMBOLS);
    private static final Map<SymbolType, Symbol> JAPANESE_SYMBOLS;
    private static final Map<SymbolType, Symbol> JAPANESE_ZENKAKU2_SYMBOLS;
    private static final Map<SymbolType, Symbol> JAPANESE_HANKAKU_SYMBOLS;

    SymbolTable(String lang, Optional<String> variant, List<Symbol> customSymbols) {
        this.lang = lang;
        this.variant = variant.orElse("");
        this.getDefaultSymbols().values().forEach(this::overrideSymbol);
        customSymbols.forEach(this::overrideSymbol);
    }

    public Map<SymbolType, Symbol> getDefaultSymbols() {
        switch (this.lang) {
            case "ja": {
                LOG.info("\"ja\" is specified.");
                switch (this.variant) {
                    case "hankaku": {
                        LOG.info("\"hankaku\" variant is specified");
                        return JAPANESE_HANKAKU_SYMBOLS;
                    }
                    case "zenkaku2": {
                        LOG.info("\"zenkaku2\" variant is specified");
                        return JAPANESE_ZENKAKU2_SYMBOLS;
                    }
                }
                this.variant = "zenkaku";
                LOG.info("\"zenkaku\" variant is specified");
                return JAPANESE_SYMBOLS;
            }
            case "ru": {
                LOG.info("\"ru\" is specified");
                return RUSSIAN_SYMBOLS;
            }
        }
        LOG.info("Default symbol settings are loaded");
        return DEFAULT_SYMBOLS;
    }

    public void overrideSymbol(Symbol symbol) {
        this.symbolDictionary.put(symbol.getType(), symbol);
        this.valueDictionary.put(Character.valueOf(symbol.getValue()), symbol);
    }

    public Set<SymbolType> getNames() {
        return this.symbolDictionary.keySet();
    }

    public Symbol getSymbol(SymbolType name) {
        return this.symbolDictionary.get((Object)name);
    }

    public Symbol getSymbolByValue(char value) {
        return this.valueDictionary.get(Character.valueOf(value));
    }

    public char getValueOrFallbackToDefault(SymbolType type) {
        Symbol symbol = this.symbolDictionary.get((Object)type);
        return symbol != null ? symbol.getValue() : DEFAULT_SYMBOLS.get((Object)type).getValue();
    }

    public boolean containsSymbolByValue(char value) {
        return this.valueDictionary.get(Character.valueOf(value)) != null;
    }

    public String getLang() {
        return this.lang;
    }

    public String getVariant() {
        return this.variant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolTable that = (SymbolTable)o;
        return Objects.equals(this.lang, that.lang) && Objects.equals(this.variant, that.variant) && Objects.equals(this.symbolDictionary, that.symbolDictionary);
    }

    public int hashCode() {
        return Objects.hash(this.lang, this.variant, this.symbolDictionary);
    }

    public SymbolTable clone() {
        try {
            SymbolTable clone = (SymbolTable)super.clone();
            clone.symbolDictionary = new LinkedHashMap<SymbolType, Symbol>(this.symbolDictionary);
            clone.valueDictionary = new LinkedHashMap<Character, Symbol>(this.valueDictionary);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "SymbolTable{symbolDictionary=" + this.symbolDictionary + ", lang='" + this.lang + '\'' + ", variant='" + this.variant + '\'' + '}';
    }

    private static Map<SymbolType, Symbol> initializeSymbols(Symbol ... newSymbols) {
        LinkedHashMap<SymbolType, Symbol> symbolTypeSymbolMap = new LinkedHashMap<SymbolType, Symbol>();
        for (Symbol symbol : newSymbols) {
            symbolTypeSymbolMap.put(symbol.getType(), symbol);
        }
        return symbolTypeSymbolMap;
    }

    static {
        RUSSIAN_SYMBOLS.put(SymbolType.NUMBER_SIGN, new Symbol(SymbolType.NUMBER_SIGN, '\u2116', "#\uff03", true, false));
        RUSSIAN_SYMBOLS.put(SymbolType.LEFT_DOUBLE_QUOTATION_MARK, new Symbol(SymbolType.LEFT_DOUBLE_QUOTATION_MARK, '\u00ab', "\"", true, false));
        RUSSIAN_SYMBOLS.put(SymbolType.RIGHT_DOUBLE_QUOTATION_MARK, new Symbol(SymbolType.RIGHT_DOUBLE_QUOTATION_MARK, '\u00bb', "\"", false, true));
        JAPANESE_SYMBOLS = SymbolTable.initializeSymbols(new Symbol(SymbolType.SPACE, '\u3000', ""), new Symbol(SymbolType.EXCLAMATION_MARK, '\uff01', "!"), new Symbol(SymbolType.NUMBER_SIGN, '\uff03', "#"), new Symbol(SymbolType.DOLLAR_SIGN, '\uff04', "$"), new Symbol(SymbolType.PERCENT_SIGN, '\uff05', ""), new Symbol(SymbolType.QUESTION_MARK, '\uff1f', "?"), new Symbol(SymbolType.AMPERSAND, '\uff06', ""), new Symbol(SymbolType.LEFT_PARENTHESIS, '\uff08', "("), new Symbol(SymbolType.RIGHT_PARENTHESIS, '\uff09', ")"), new Symbol(SymbolType.ASTERISK, '\uff0a', ""), new Symbol(SymbolType.COMMA, '\u3001', ",\uff0c"), new Symbol(SymbolType.FULL_STOP, '\u3002', ".\uff0e"), new Symbol(SymbolType.PLUS_SIGN, '\uff0b', ""), new Symbol(SymbolType.HYPHEN_SIGN, '\u30fc', ""), new Symbol(SymbolType.SLASH, '\uff0f', ""), new Symbol(SymbolType.COLON, '\uff1a', ""), new Symbol(SymbolType.SEMICOLON, '\uff1b', ""), new Symbol(SymbolType.LESS_THAN_SIGN, '\uff1c', ""), new Symbol(SymbolType.EQUAL_SIGN, '\uff1d', ""), new Symbol(SymbolType.GREATER_THAN_SIGN, '\uff1e', ""), new Symbol(SymbolType.AT_MARK, '\uff20', ""), new Symbol(SymbolType.LEFT_SQUARE_BRACKET, '\u300c', ""), new Symbol(SymbolType.RIGHT_SQUARE_BRACKET, '\u300d', ""), new Symbol(SymbolType.BACKSLASH, '\u00a5', "\\"), new Symbol(SymbolType.CIRCUMFLEX_ACCENT, '\uff3e', ""), new Symbol(SymbolType.LOW_LINE, '\uff3f', ""), new Symbol(SymbolType.LEFT_CURLY_BRACKET, '\uff5b', ""), new Symbol(SymbolType.RIGHT_CURLY_BRACKET, '\uff5d', ""), new Symbol(SymbolType.VERTICAL_BAR, '\uff5c', "|"), new Symbol(SymbolType.TILDE, '\u301c', "~"), new Symbol(SymbolType.LEFT_SINGLE_QUOTATION_MARK, '\u2018', ""), new Symbol(SymbolType.RIGHT_SINGLE_QUOTATION_MARK, '\u2019', ""), new Symbol(SymbolType.LEFT_SINGLE_QUOTATION_MARK, '\u201c', ""), new Symbol(SymbolType.RIGHT_DOUBLE_QUOTATION_MARK, '\u201d', ""), new Symbol(SymbolType.DIGIT_ZERO, '0', ""), new Symbol(SymbolType.DIGIT_ONE, '1', ""), new Symbol(SymbolType.DIGIT_TWO, '2', ""), new Symbol(SymbolType.DIGIT_THREE, '3', ""), new Symbol(SymbolType.DIGIT_FOUR, '4', ""), new Symbol(SymbolType.DIGIT_FIVE, '5', ""), new Symbol(SymbolType.DIGIT_SIX, '6', ""), new Symbol(SymbolType.DIGIT_SEVEN, '7', ""), new Symbol(SymbolType.DIGIT_EIGHT, '8', ""), new Symbol(SymbolType.DIGIT_NINE, '9', ""));
        JAPANESE_ZENKAKU2_SYMBOLS = new LinkedHashMap<SymbolType, Symbol>(JAPANESE_SYMBOLS);
        JAPANESE_ZENKAKU2_SYMBOLS.put(SymbolType.FULL_STOP, new Symbol(SymbolType.FULL_STOP, '\uff0e', "\u3002."));
        JAPANESE_ZENKAKU2_SYMBOLS.put(SymbolType.COMMA, new Symbol(SymbolType.COMMA, '\uff0c', "\u3001,"));
        JAPANESE_HANKAKU_SYMBOLS = SymbolTable.initializeSymbols(new Symbol(SymbolType.SPACE, '\u3000', " "), new Symbol(SymbolType.EXCLAMATION_MARK, '!', "\uff01"), new Symbol(SymbolType.NUMBER_SIGN, '#', "\uff03"), new Symbol(SymbolType.DOLLAR_SIGN, '$', "\uff04"), new Symbol(SymbolType.PERCENT_SIGN, '%', "\uff05"), new Symbol(SymbolType.QUESTION_MARK, '?', "\uff1f"), new Symbol(SymbolType.AMPERSAND, '&', "\uff06"), new Symbol(SymbolType.LEFT_PARENTHESIS, '(', "\uff08", true, false), new Symbol(SymbolType.RIGHT_PARENTHESIS, ')', "\uff09", false, true), new Symbol(SymbolType.ASTERISK, '*', "\uff0a"), new Symbol(SymbolType.COMMA, ',', "\uff0c\u3001", false, true), new Symbol(SymbolType.FULL_STOP, '.', "\uff0e\u3002"), new Symbol(SymbolType.PLUS_SIGN, '+', "\uff0b"), new Symbol(SymbolType.HYPHEN_SIGN, '-', "\u30fc"), new Symbol(SymbolType.SLASH, '/', "\uff0f"), new Symbol(SymbolType.COLON, ':', "\uff1a"), new Symbol(SymbolType.SEMICOLON, ';', "\uff1b"), new Symbol(SymbolType.LESS_THAN_SIGN, '<', "\uff1c"), new Symbol(SymbolType.EQUAL_SIGN, '=', "\uff1d"), new Symbol(SymbolType.GREATER_THAN_SIGN, '>', "\uff1e"), new Symbol(SymbolType.AT_MARK, '@', "\uff20"), new Symbol(SymbolType.LEFT_SQUARE_BRACKET, '[', "", true, false), new Symbol(SymbolType.RIGHT_SQUARE_BRACKET, ']', "", false, true), new Symbol(SymbolType.BACKSLASH, '\\', ""), new Symbol(SymbolType.CIRCUMFLEX_ACCENT, '^', ""), new Symbol(SymbolType.LOW_LINE, '_', ""), new Symbol(SymbolType.LEFT_CURLY_BRACKET, '{', "\uff5b", true, false), new Symbol(SymbolType.RIGHT_CURLY_BRACKET, '}', "\uff5d", false, true), new Symbol(SymbolType.VERTICAL_BAR, '|', "\uff5c"), new Symbol(SymbolType.TILDE, '~', "\u301c"), new Symbol(SymbolType.LEFT_SINGLE_QUOTATION_MARK, '\'', ""), new Symbol(SymbolType.RIGHT_SINGLE_QUOTATION_MARK, '\'', ""), new Symbol(SymbolType.LEFT_DOUBLE_QUOTATION_MARK, '\"', ""), new Symbol(SymbolType.RIGHT_DOUBLE_QUOTATION_MARK, '\"', ""), new Symbol(SymbolType.DIGIT_ZERO, '0', "\uff10"), new Symbol(SymbolType.DIGIT_ONE, '1', "\uff11"), new Symbol(SymbolType.DIGIT_TWO, '2', "\uff12"), new Symbol(SymbolType.DIGIT_THREE, '3', "\uff13"), new Symbol(SymbolType.DIGIT_FOUR, '4', "\uff14"), new Symbol(SymbolType.DIGIT_FIVE, '5', "\uff15"), new Symbol(SymbolType.DIGIT_SIX, '6', "\uff16"), new Symbol(SymbolType.DIGIT_SEVEN, '7', "\uff17"), new Symbol(SymbolType.DIGIT_EIGHT, '8', "\uff18"), new Symbol(SymbolType.DIGIT_NINE, '9', "\uff19"));
    }
}

