/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ValidatorConfiguration
implements Serializable,
Cloneable {
    private final String configurationName;
    private Map<String, String> properties;

    public ValidatorConfiguration(String name) {
        this(name, new HashMap<String, String>());
    }

    public ValidatorConfiguration(String name, Map<String, String> properties) {
        this.configurationName = name;
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public String getValidatorClassName() {
        return this.configurationName + "Validator";
    }

    public ValidatorConfiguration addProperty(String name, Object value) {
        this.properties.put(name, String.valueOf(value));
        return this;
    }

    @Deprecated
    public ValidatorConfiguration addAttribute(String name, Object value) {
        return this.addProperty(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidatorConfiguration)) {
            return false;
        }
        ValidatorConfiguration that = (ValidatorConfiguration)o;
        return Objects.equals(this.configurationName, that.configurationName) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.configurationName);
    }

    public String toString() {
        return this.configurationName;
    }

    public ValidatorConfiguration clone() {
        try {
            ValidatorConfiguration clone = (ValidatorConfiguration)super.clone();
            clone.properties = new HashMap<String, String>(this.properties);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

