/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.formatter;

import cc.redpen.RedPenException;
import cc.redpen.model.Document;
import cc.redpen.validator.ValidationError;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Formatter {
    private static final Logger LOG = LoggerFactory.getLogger(Formatter.class);

    public abstract void format(PrintWriter var1, Map<Document, List<ValidationError>> var2) throws RedPenException, IOException;

    public abstract String formatError(Document var1, ValidationError var2) throws RedPenException;

    public void format(OutputStream outputStream, Map<Document, List<ValidationError>> docErrorsMap) throws RedPenException, IOException {
        this.format(new PrintWriter(outputStream), docErrorsMap);
    }

    public String format(Map<Document, List<ValidationError>> docErrorsMap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.format(new PrintWriter(baos), docErrorsMap);
        }
        catch (RedPenException | IOException e) {
            throw new RuntimeException(e);
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    public String format(Document document, List<ValidationError> errors) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HashMap<Document, List<ValidationError>> docErrorsMap = new HashMap<Document, List<ValidationError>>();
        docErrorsMap.put(document, errors);
        try {
            this.format(new PrintWriter(baos), docErrorsMap);
        }
        catch (RedPenException | IOException e) {
            throw new RuntimeException(e);
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }
}

