/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.formatter;

import cc.redpen.formatter.JSONFormatter;
import cc.redpen.model.Document;
import cc.redpen.model.Sentence;
import cc.redpen.parser.LineOffset;
import cc.redpen.validator.ValidationError;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONBySentenceFormatter
extends JSONFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(JSONBySentenceFormatter.class);
    public static final Comparator<ValidationError> BY_SENTENCE_COMPARATOR = new Comparator<ValidationError>(){

        @Override
        public int compare(ValidationError error1, ValidationError error2) {
            if (error1 == null || error2 == null) {
                return -1;
            }
            Sentence sentence1 = error1.getSentence();
            Sentence sentence2 = error2.getSentence();
            int lineComp = sentence1.getLineNumber() - sentence2.getLineNumber();
            if (lineComp == 0) {
                int offsetComp = sentence1.getStartPositionOffset() - sentence2.getStartPositionOffset();
                if (offsetComp == 0) {
                    return sentence1.getContent().compareTo(sentence2.getContent());
                }
                return offsetComp;
            }
            return lineComp;
        }
    };

    @Override
    protected JSONObject asJSON(ValidationError error) throws JSONException {
        JSONObject jsonError = new JSONObject();
        jsonError.put("message", (Object)error.getMessage());
        jsonError.put("validator", (Object)error.getValidatorName());
        LineOffset startOffset = error.getStartPosition().isPresent() ? error.getStartPosition().get() : new LineOffset(error.getSentence().getLineNumber(), error.getSentence().getStartPositionOffset());
        LineOffset endOffset = error.getEndPosition().isPresent() ? error.getEndPosition().get() : new LineOffset(error.getSentence().getLineNumber(), error.getSentence().getStartPositionOffset());
        jsonError.put("position", (Object)this.asJSON(startOffset, endOffset));
        jsonError.put("subsentence", (Object)this.asJSON(error.getSentence(), startOffset, endOffset));
        return jsonError;
    }

    @Override
    protected JSONObject asJSON(Document document, List<ValidationError> errors) {
        ArrayList<ValidationError> sortedErrors = new ArrayList<ValidationError>(errors);
        sortedErrors.sort(BY_SENTENCE_COMPARATOR);
        JSONObject jsonErrors = new JSONObject();
        try {
            if (document.getFileName().isPresent()) {
                jsonErrors.put("document", (Object)document.getFileName().get());
            }
            JSONArray documentErrors = new JSONArray();
            jsonErrors.put("errors", (Object)documentErrors);
            JSONArray sentenceErrors = new JSONArray();
            ValidationError lastError = null;
            for (ValidationError error : sortedErrors) {
                if (BY_SENTENCE_COMPARATOR.compare(lastError, error) != 0) {
                    JSONObject sentenceError = new JSONObject();
                    sentenceError.put("sentence", (Object)error.getSentence().getContent());
                    Sentence sentence = error.getSentence();
                    LineOffset lastPosition = sentence.getOffset(sentence.getContent().length() - 1).orElse(new LineOffset(sentence.getLineNumber(), sentence.getStartPositionOffset() + sentence.getContent().length()));
                    sentenceError.put("position", (Object)this.asJSON(sentence.getLineNumber(), sentence.getStartPositionOffset(), lastPosition.lineNum, lastPosition.offset));
                    sentenceErrors = new JSONArray();
                    sentenceError.put("errors", (Object)sentenceErrors);
                    documentErrors.put((Object)sentenceError);
                    lastError = error;
                }
                sentenceErrors.put((Object)this.asJSON(error));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return jsonErrors;
    }
}

