/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.formatter;

import cc.redpen.RedPenException;
import cc.redpen.formatter.Formatter;
import cc.redpen.model.Document;
import cc.redpen.model.Sentence;
import cc.redpen.parser.LineOffset;
import cc.redpen.validator.ValidationError;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONFormatter
extends Formatter {
    private static final Logger LOG = LoggerFactory.getLogger(JSONFormatter.class);

    @Override
    public void format(PrintWriter pw, Map<Document, List<ValidationError>> docErrorsMap) throws RedPenException, IOException {
        BufferedWriter writer = new BufferedWriter(new PrintWriter(pw));
        JSONArray errors = new JSONArray();
        docErrorsMap.forEach((doc, errorList) -> errors.put((Object)this.asJSON((Document)doc, (List<ValidationError>)errorList)));
        writer.write(errors.toString());
        writer.flush();
    }

    @Override
    public String format(Document document, List<ValidationError> errors) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new PrintWriter(baos));
        try {
            writer.write(this.asJSON(document, errors).toString());
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    @Override
    public String formatError(Document document, ValidationError error) throws RedPenException {
        try {
            return this.asJSON(error).toString();
        }
        catch (Exception e) {
            throw new RedPenException(e);
        }
    }

    protected JSONObject asJSON(ValidationError error) throws JSONException {
        JSONObject jsonError = new JSONObject();
        jsonError.put("sentence", (Object)error.getSentence().getContent());
        jsonError.put("lineNum", error.getLineNumber());
        jsonError.put("message", (Object)error.getMessage());
        jsonError.put("validator", (Object)error.getValidatorName());
        jsonError.put("sentenceStartColumnNum", error.getStartColumnNumber());
        if (error.getStartPosition().isPresent()) {
            jsonError.put("startPosition", (Object)this.asJSON(error.getStartPosition().get()));
        }
        if (error.getEndPosition().isPresent()) {
            jsonError.put("endPosition", (Object)this.asJSON(error.getEndPosition().get()));
        }
        return jsonError;
    }

    protected JSONObject asJSON(LineOffset lineOffset) throws JSONException {
        JSONObject offset = new JSONObject();
        offset.put("lineNum", lineOffset.lineNum);
        offset.put("offset", lineOffset.offset);
        return offset;
    }

    protected JSONObject asJSON(LineOffset startLineOffset, LineOffset endLineOffset) throws JSONException {
        JSONObject json = this.asJSON(startLineOffset.lineNum, startLineOffset.offset, endLineOffset.lineNum, endLineOffset.offset);
        return json;
    }

    protected JSONObject asJSON(int startLine, int startOffset, int endLine, int endOffset) throws JSONException {
        JSONObject position = new JSONObject();
        JSONObject offset = new JSONObject();
        offset.put("line", startLine);
        offset.put("offset", startOffset);
        position.put("start", (Object)offset);
        offset = new JSONObject();
        offset.put("line", endLine);
        offset.put("offset", endOffset);
        position.put("end", (Object)offset);
        return position;
    }

    protected JSONObject asJSON(Sentence sentence, LineOffset startLineOffset, LineOffset endLineOffset) throws JSONException {
        JSONObject json = new JSONObject();
        int start = sentence.getOffsetPosition(startLineOffset);
        int length = Math.max(sentence.getOffsetPosition(endLineOffset) - start, 0);
        json.put("offset", start);
        json.put("length", length);
        return json;
    }

    protected JSONObject asJSON(Document document, List<ValidationError> errors) {
        JSONObject jsonErrors = new JSONObject();
        try {
            if (document.getFileName().isPresent()) {
                jsonErrors.put("document", (Object)document.getFileName().get());
            }
            JSONArray documentErrors = new JSONArray();
            for (ValidationError error : errors) {
                documentErrors.put((Object)this.asJSON(error));
            }
            jsonErrors.put("errors", (Object)documentErrors);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return jsonErrors;
    }
}

