/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.formatter;

import cc.redpen.RedPenException;
import cc.redpen.formatter.Formatter;
import cc.redpen.formatter.JSONBySentenceFormatter;
import cc.redpen.model.Document;
import cc.redpen.validator.ValidationError;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlainBySentenceFormatter
extends Formatter {
    private static final Logger LOG = LoggerFactory.getLogger(PlainBySentenceFormatter.class);

    @Override
    public void format(PrintWriter pw, Map<Document, List<ValidationError>> docErrorsMap) throws RedPenException, IOException {
        BufferedWriter writer = new BufferedWriter(new PrintWriter(pw));
        for (Document document : docErrorsMap.keySet()) {
            if (document.getFileName().isPresent()) {
                writer.write("Document: " + document.getFileName().get() + "\n");
            }
            List<ValidationError> errors = docErrorsMap.get(document);
            errors.sort(JSONBySentenceFormatter.BY_SENTENCE_COMPARATOR);
            ValidationError lastError = null;
            for (ValidationError error : errors) {
                if (JSONBySentenceFormatter.BY_SENTENCE_COMPARATOR.compare(lastError, error) != 0) {
                    writer.write("\tLine: " + error.getSentence().getLineNumber() + ", Offset: " + error.getSentence().getStartPositionOffset() + "\n");
                    writer.write("\t\tSentence: " + error.getSentence().getContent() + "\n");
                    lastError = error;
                }
                writer.write("\t\t\t" + this.formatError(document, error));
            }
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            LOG.error("failed to flush", (Throwable)e);
        }
    }

    @Override
    public String formatError(Document document, ValidationError error) {
        StringBuilder str = new StringBuilder();
        str.append(error.getValidatorName()).append(": ");
        str.append(error.getMessage());
        str.append("\n");
        return str.toString();
    }
}

