/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.formatter;

import cc.redpen.RedPenException;
import cc.redpen.formatter.Formatter;
import cc.redpen.model.Document;
import cc.redpen.validator.ValidationError;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlainFormatter
extends Formatter {
    private static final Logger LOG = LoggerFactory.getLogger(PlainFormatter.class);

    @Override
    public void format(PrintWriter pw, Map<Document, List<ValidationError>> docErrorsMap) throws RedPenException, IOException {
        BufferedWriter writer = new BufferedWriter(new PrintWriter(pw));
        for (Document document : docErrorsMap.keySet()) {
            List<ValidationError> errors = docErrorsMap.get(document);
            for (ValidationError error : errors) {
                writer.write(this.formatError(document, error));
            }
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            LOG.error("failed to flush", (Throwable)e);
        }
    }

    @Override
    public String formatError(Document document, ValidationError error) {
        StringBuilder str = new StringBuilder();
        document.getFileName().ifPresent(e -> str.append((String)e).append(":"));
        str.append(error.getLineNumber());
        str.append(": ValidationError[").append(error.getValidatorName()).append("], ");
        str.append(error.getMessage());
        str.append(" at line: ").append(error.getSentence().getContent());
        str.append("\n");
        return str.toString();
    }
}

