/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.formatter;

import cc.redpen.RedPenException;
import cc.redpen.formatter.Formatter;
import cc.redpen.model.Document;
import cc.redpen.parser.LineOffset;
import cc.redpen.validator.ValidationError;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLFormatter
extends Formatter {
    private static final Logger LOG = LoggerFactory.getLogger(XMLFormatter.class);
    private DocumentBuilder db;
    private final Transformer transformer;

    public XMLFormatter() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            this.db = dbf.newDocumentBuilder();
            TransformerFactory tf = TransformerFactory.newInstance();
            this.transformer = tf.newTransformer();
            this.transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (ParserConfigurationException | TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void format(PrintWriter pw, Map<Document, List<ValidationError>> docErrorsMap) throws RedPenException, IOException {
        BufferedWriter writer = new BufferedWriter(new PrintWriter(pw));
        writer.write("<validation-result>\n");
        for (Document document : docErrorsMap.keySet()) {
            List<ValidationError> errors = docErrorsMap.get(document);
            for (ValidationError error : errors) {
                writer.write(this.formatError(document, error));
            }
        }
        writer.write("</validation-result>");
        writer.flush();
    }

    @Override
    public String formatError(Document document, ValidationError error) throws RedPenException {
        org.w3c.dom.Document doc = this.db.newDocument();
        Element errorElement = doc.createElement("error");
        doc.appendChild(errorElement);
        Element validatorElement = doc.createElement("validator");
        errorElement.appendChild(validatorElement);
        Text validator = doc.createTextNode(error.getValidatorName());
        validatorElement.appendChild(validator);
        Element contentElement = doc.createElement("message");
        errorElement.appendChild(contentElement);
        Text content = doc.createTextNode(error.getMessage());
        contentElement.appendChild(content);
        document.getFileName().ifPresent(e -> {
            Element fileNameElement = doc.createElement("file");
            errorElement.appendChild(fileNameElement);
            Text fileName = doc.createTextNode((String)e);
            fileNameElement.appendChild(fileName);
        });
        Element lineNumberElement = doc.createElement("lineNum");
        errorElement.appendChild(lineNumberElement);
        Text lineNum = doc.createTextNode(Integer.toString(error.getLineNumber()));
        lineNumberElement.appendChild(lineNum);
        Element sentenceStartOffset = doc.createElement("sentenceStartColumnNum");
        errorElement.appendChild(sentenceStartOffset);
        Text offset = doc.createTextNode(Integer.toString(error.getStartColumnNumber()));
        sentenceStartOffset.appendChild(offset);
        Element sentenceElement = doc.createElement("sentence");
        errorElement.appendChild(sentenceElement);
        sentenceElement.appendChild(doc.createTextNode(error.getSentence().getContent()));
        error.getStartPosition().ifPresent(e -> {
            Element startPositionElement = doc.createElement("errorStartPosition");
            errorElement.appendChild(startPositionElement);
            LineOffset startOffset = error.getStartPosition().get();
            startPositionElement.appendChild(doc.createTextNode(Integer.toString(startOffset.lineNum) + "," + Integer.toString(startOffset.offset)));
        });
        error.getStartPosition().ifPresent(e -> {
            Element endPositionElement = doc.createElement("errorEndPosition");
            errorElement.appendChild(endPositionElement);
            LineOffset endOffset = error.getEndPosition().get();
            endPositionElement.appendChild(doc.createTextNode(Integer.toString(endOffset.lineNum) + "," + Integer.toString(endOffset.offset)));
        });
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        DOMSource source = new DOMSource(doc);
        try {
            this.transformer.transform(source, result);
        }
        catch (TransformerException e2) {
            throw new RedPenException(e2);
        }
        return writer.toString() + "\n";
    }
}

