/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.model;

import cc.redpen.model.Paragraph;
import cc.redpen.model.Section;
import cc.redpen.model.Sentence;
import cc.redpen.parser.PreprocessorRule;
import cc.redpen.tokenizer.RedPenTokenizer;
import cc.redpen.tokenizer.WhiteSpaceTokenizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class Document
implements Iterable<Section>,
Serializable {
    private static final long serialVersionUID = 1628589004095293831L;
    private final List<Section> sections;
    private final Optional<String> fileName;
    private final Set<PreprocessorRule> preprocessorRules;

    public Document(List<Section> sections, Optional<String> fileName, Set<PreprocessorRule> preprocessorRules) {
        this.sections = sections;
        this.fileName = fileName;
        this.preprocessorRules = preprocessorRules;
    }

    public Section getLastSection() {
        Section section = null;
        if (this.sections.size() > 0) {
            section = this.sections.get(this.sections.size() - 1);
        }
        return section;
    }

    public int size() {
        return this.sections.size();
    }

    public Section getSection(int id) {
        return this.sections.get(id);
    }

    public Optional<String> getFileName() {
        return this.fileName;
    }

    @Override
    public Iterator<Section> iterator() {
        return this.sections.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document sections1 = (Document)o;
        if (this.fileName != null ? !this.fileName.equals(sections1.fileName) : sections1.fileName != null) {
            return false;
        }
        return !(this.sections != null ? !this.sections.equals(sections1.sections) : sections1.sections != null);
    }

    public Set<PreprocessorRule> getPreprocessorRules() {
        return this.preprocessorRules;
    }

    public int hashCode() {
        int result = this.sections != null ? this.sections.hashCode() : 0;
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Document{sections=" + this.sections + ", fileName=" + this.fileName + '}';
    }

    public static DocumentBuilder builder() {
        return new DocumentBuilder();
    }

    public static DocumentBuilder builder(RedPenTokenizer tokenizer) {
        return new DocumentBuilder(tokenizer);
    }

    public static class DocumentBuilder {
        private final RedPenTokenizer tokenizer;
        boolean built = false;
        private final List<Section> sections = new ArrayList<Section>();
        Optional<String> fileName = Optional.empty();
        private Set<PreprocessorRule> preprocessorRules;

        public DocumentBuilder() {
            this(new WhiteSpaceTokenizer());
        }

        public DocumentBuilder(RedPenTokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        public DocumentBuilder appendSection(Section section) {
            this.ensureNotBuilt();
            for (Sentence sentence : section.getHeaderContents()) {
                sentence.setTokens(this.tokenizer.tokenize(sentence.getContent()));
            }
            this.sections.add(section);
            return this;
        }

        public DocumentBuilder addSentence(Sentence sentence) {
            Section lastSection;
            this.ensureNotBuilt();
            if (this.sections.size() == 0) {
                ArrayList<Sentence> headers = new ArrayList<Sentence>();
                headers.add(new Sentence("", 0));
                this.appendSection(new Section(0, headers));
            }
            if ((lastSection = this.getSection(this.sections.size() - 1)).getNumberOfParagraphs() == 0) {
                this.addParagraph();
            }
            Paragraph lastParagraph = lastSection.getParagraph(lastSection.getNumberOfParagraphs() - 1);
            lastParagraph.appendSentence(sentence);
            if (lastParagraph.getNumberOfSentences() == 1) {
                sentence.setIsFirstSentence(true);
            }
            sentence.setTokens(this.tokenizer.tokenize(sentence.getContent()));
            return this;
        }

        public Section getLastSection() {
            Section section = null;
            if (this.sections.size() > 0) {
                section = this.sections.get(this.sections.size() - 1);
            }
            return section;
        }

        public Section getSection(int id) {
            return this.sections.get(id);
        }

        public DocumentBuilder addParagraph() {
            this.ensureNotBuilt();
            if (this.sections.size() == 0) {
                ArrayList<Sentence> headers = new ArrayList<Sentence>();
                headers.add(new Sentence("", 0));
                this.appendSection(new Section(0, headers));
            }
            Section lastSection = this.getSection(this.sections.size() - 1);
            lastSection.appendParagraph(new Paragraph());
            return this;
        }

        public DocumentBuilder addListBlock() {
            this.ensureNotBuilt();
            if (this.sections.size() == 0) {
                throw new IllegalStateException("No section to add a sentence");
            }
            Section lastSection = this.getSection(this.sections.size() - 1);
            lastSection.appendListBlock();
            return this;
        }

        public DocumentBuilder addListElement(int level, List<Sentence> contents) {
            this.ensureNotBuilt();
            if (this.sections.size() == 0) {
                throw new IllegalStateException("No section to add a sentence");
            }
            Section lastSection = this.getSection(this.sections.size() - 1);
            for (Sentence sentence : contents) {
                sentence.setTokens(this.tokenizer.tokenize(sentence.getContent()));
            }
            lastSection.appendListElement(level, contents);
            return this;
        }

        public DocumentBuilder addListElement(int level, String str) {
            this.ensureNotBuilt();
            ArrayList<Sentence> elementSentence = new ArrayList<Sentence>();
            elementSentence.add(new Sentence(str, 0));
            this.addListElement(level, elementSentence);
            return this;
        }

        public DocumentBuilder addSection(int level, List<Sentence> header) {
            this.ensureNotBuilt();
            this.appendSection(new Section(level, header));
            return this;
        }

        public DocumentBuilder addSectionHeader(String header) {
            this.ensureNotBuilt();
            Section lastSection = this.getLastSection();
            if (null == lastSection) {
                throw new IllegalStateException("Document does not have any section");
            }
            List<Sentence> headers = lastSection.getHeaderContents();
            Sentence sentence = new Sentence(header, headers.size());
            sentence.setTokens(this.tokenizer.tokenize(sentence.getContent()));
            headers.add(sentence);
            return this;
        }

        public DocumentBuilder addSection(int level) {
            this.ensureNotBuilt();
            this.addSection(level, new ArrayList<Sentence>());
            return this;
        }

        public DocumentBuilder addSentence(String content, int lineNumber) {
            this.ensureNotBuilt();
            this.addSentence(new Sentence(content, lineNumber));
            return this;
        }

        public DocumentBuilder setFileName(String name) {
            this.ensureNotBuilt();
            this.fileName = Optional.of(name);
            return this;
        }

        public DocumentBuilder setPreprocessorRules(Set<PreprocessorRule> rules) {
            this.preprocessorRules = rules;
            return this;
        }

        private void ensureNotBuilt() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
        }

        public Document build() {
            this.built = true;
            return new Document(this.sections, this.fileName, this.preprocessorRules);
        }
    }
}

