/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.model;

import cc.redpen.model.ListBlock;
import cc.redpen.model.Paragraph;
import cc.redpen.model.Sentence;
import java.util.ArrayList;
import java.util.List;

public class Section {
    private final List<Section> subsections;
    private final List<Paragraph> paragraphs;
    private final List<ListBlock> lists;
    private List<Sentence> headerContent;
    private int level;
    private Section parent;

    public Section(int sectionLevel) {
        this.level = sectionLevel;
        this.headerContent = new ArrayList<Sentence>();
        this.subsections = new ArrayList<Section>();
        this.paragraphs = new ArrayList<Paragraph>();
        this.lists = new ArrayList<ListBlock>();
    }

    public Section(int sectionLevel, List<Sentence> header) {
        this.level = sectionLevel;
        this.headerContent = header;
        this.subsections = new ArrayList<Section>();
        this.paragraphs = new ArrayList<Paragraph>();
        this.lists = new ArrayList<ListBlock>();
    }

    public Section(int sectionLevel, String headerString) {
        Sentence headerSentence = new Sentence(headerString, 0);
        ArrayList<Sentence> headers = new ArrayList<Sentence>();
        headers.add(headerSentence);
        this.level = sectionLevel;
        this.headerContent = headers;
        this.subsections = new ArrayList<Section>();
        this.paragraphs = new ArrayList<Paragraph>();
        this.lists = new ArrayList<ListBlock>();
    }

    public void appendSubSection(Section section) {
        this.subsections.add(section);
    }

    public Section getSubSection(int id) {
        return this.subsections.get(id);
    }

    public Section getParentSection() {
        return this.parent;
    }

    public void setParentSection(Section parentSection) {
        this.parent = parentSection;
    }

    public int getNumberOfSubsections() {
        return this.subsections.size();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int sectionLevel) {
        this.level = sectionLevel;
    }

    public List<Sentence> getHeaderContents() {
        return this.headerContent;
    }

    public Sentence getHeaderContent(int id) {
        if (this.headerContent.size() > id) {
            return this.headerContent.get(id);
        }
        return null;
    }

    public Sentence getJoinedHeaderContents() {
        StringBuilder joinedHeader = new StringBuilder();
        int lineNum = 0;
        if (this.headerContent.size() > 0) {
            lineNum = this.headerContent.get(0).getLineNumber();
        }
        int i = 0;
        for (Sentence header : this.headerContent) {
            if (i != 0) {
                joinedHeader.append(" ");
            }
            joinedHeader.append(header.getContent());
            ++i;
        }
        return new Sentence(joinedHeader.toString(), lineNum);
    }

    public int getHeaderContentsListSize() {
        return this.headerContent.size();
    }

    public List<Paragraph> getParagraphs() {
        return this.paragraphs;
    }

    public Paragraph getParagraph(int id) {
        return this.paragraphs.get(id);
    }

    public void appendParagraph(Paragraph paragraph) {
        this.paragraphs.add(paragraph);
    }

    public void appendListBlock() {
        this.lists.add(new ListBlock());
    }

    public void appendListElement(int listLevel, List<Sentence> contents) {
        if (this.lists.isEmpty()) {
            this.appendListBlock();
        }
        this.lists.get(this.lists.size() - 1).appendElement(listLevel, contents);
    }

    public int getNumberOfLists() {
        return this.lists.size();
    }

    public ListBlock getListBlock(int id) {
        return this.lists.get(id);
    }

    public List<ListBlock> getListBlocks() {
        return this.lists;
    }

    public int getNumberOfParagraphs() {
        return this.paragraphs.size();
    }
}

