/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.model;

import cc.redpen.parser.LineOffset;
import cc.redpen.tokenizer.TokenElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Sentence
implements Serializable {
    private static final long serialVersionUID = 3761982769692999924L;
    private final List<String> links;
    private int lineNumber;
    private String content;
    private int startPositionOffset;
    private boolean isFirstSentence;
    private List<TokenElement> tokens;
    private List<LineOffset> offsetMap;

    public Sentence(String sentenceContent, int lineNum) {
        this(sentenceContent, lineNum, 0);
    }

    public Sentence(String sentenceContent, int lineNum, int startOffset) {
        this.content = sentenceContent;
        this.lineNumber = lineNum;
        this.isFirstSentence = false;
        this.links = new ArrayList<String>();
        this.tokens = new ArrayList<TokenElement>();
        this.startPositionOffset = startOffset;
        this.offsetMap = new ArrayList<LineOffset>();
    }

    public Sentence(String content, List<LineOffset> offsetMap, List<String> links) {
        this.content = content;
        this.offsetMap = offsetMap;
        this.startPositionOffset = offsetMap.get((int)0).offset;
        this.lineNumber = offsetMap.get((int)0).lineNum;
        this.isFirstSentence = false;
        this.tokens = new ArrayList<TokenElement>();
        this.links = links;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public List<String> getLinks() {
        return this.links;
    }

    public void addLink(String link) {
        this.links.add(link);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getStartPositionOffset() {
        return this.startPositionOffset;
    }

    public boolean isFirstSentence() {
        return this.isFirstSentence;
    }

    public void setIsFirstSentence(boolean isFirstSentence) {
        this.isFirstSentence = isFirstSentence;
    }

    public List<TokenElement> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<TokenElement> tokens) {
        this.tokens = tokens;
    }

    public void setOffsetMap(List<LineOffset> offsetMap) {
        this.offsetMap = offsetMap;
    }

    public Optional<LineOffset> getOffset(int position) {
        if (position >= 0) {
            if (this.offsetMap.size() > position) {
                return Optional.of(this.offsetMap.get(position));
            }
            if (position > 0 && this.offsetMap.size() == position) {
                LineOffset last = this.offsetMap.get(this.offsetMap.size() - 1);
                return Optional.of(new LineOffset(last.lineNum, last.offset + 1));
            }
            return Optional.of(new LineOffset(this.lineNumber, position));
        }
        return Optional.empty();
    }

    public int getOffsetPosition(LineOffset offset) {
        int position = this.offsetMap.indexOf(offset);
        return position < 0 ? 0 : position;
    }

    public int getOffsetMapSize() {
        return this.offsetMap.size();
    }

    public String toString() {
        return "Sentence{links=" + this.links + ", lineNumber=" + this.lineNumber + ", content='" + this.content + '\'' + ", startPositionOffset=" + this.startPositionOffset + ", isFirstSentence=" + this.isFirstSentence + ", tokens=" + this.tokens + ", offsetMap=" + this.offsetMap + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sentence sentence = (Sentence)o;
        if (this.isFirstSentence != sentence.isFirstSentence) {
            return false;
        }
        if (this.lineNumber != sentence.lineNumber) {
            return false;
        }
        if (this.startPositionOffset != sentence.startPositionOffset) {
            return false;
        }
        if (this.content != null ? !this.content.equals(sentence.content) : sentence.content != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(sentence.links) : sentence.links != null) {
            return false;
        }
        return !(this.tokens != null ? !this.tokens.equals(sentence.tokens) : sentence.tokens != null);
    }

    public int hashCode() {
        int result = this.links != null ? this.links.hashCode() : 0;
        result = 31 * result + this.lineNumber;
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        result = 31 * result + this.startPositionOffset;
        result = 31 * result + (this.isFirstSentence ? 1 : 0);
        result = 31 * result + (this.tokens != null ? this.tokens.hashCode() : 0);
        return result;
    }

    public List<LineOffset> getOffsetMap() {
        return this.offsetMap;
    }
}

