/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser;

import cc.redpen.RedPenException;
import cc.redpen.model.Document;
import cc.redpen.model.Sentence;
import cc.redpen.parser.DocumentParser;
import cc.redpen.parser.LineOffset;
import cc.redpen.parser.PreprocessingReader;
import cc.redpen.parser.SentenceExtractor;
import cc.redpen.tokenizer.RedPenTokenizer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class BaseDocumentParser
implements DocumentParser {
    @Override
    public Document parse(InputStream is, SentenceExtractor sentenceExtractor, RedPenTokenizer tokenizer) throws RedPenException {
        return this.parse(is, Optional.empty(), sentenceExtractor, tokenizer);
    }

    @Override
    public Document parse(String content, SentenceExtractor sentenceExtractor, RedPenTokenizer tokenizer) throws RedPenException {
        return this.parse(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), sentenceExtractor, tokenizer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Document parse(File file, SentenceExtractor sentenceExtractor, RedPenTokenizer tokenizer) throws RedPenException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            Document document = this.parse(inputStream, Optional.of(file.getName()), sentenceExtractor, tokenizer);
            return document;
        }
        catch (IOException e) {
            throw new RedPenException(e);
        }
    }

    protected abstract Document parse(InputStream var1, Optional<String> var2, SentenceExtractor var3, RedPenTokenizer var4) throws RedPenException;

    protected PreprocessingReader createReader(InputStream is) {
        return new PreprocessingReader(new InputStreamReader(is, StandardCharsets.UTF_8), this);
    }

    protected int skipWhitespace(String line, int start) {
        for (int i = start; i < line.length(); ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            return i;
        }
        return line.length();
    }

    protected static class ValueWithOffsets
    extends Sentence {
        public ValueWithOffsets() {
            super("", 0);
        }

        public ValueWithOffsets(String content, List<LineOffset> offsetMap) {
            super(content, offsetMap, new ArrayList<String>());
        }

        public boolean isEmpty() {
            return "".equals(this.getContent());
        }

        public ValueWithOffsets append(String line, List<LineOffset> offsets) {
            this.setContent(this.getContent() + line);
            this.getOffsetMap().addAll(offsets);
            return this;
        }

        public ValueWithOffsets extract(int start, int end) {
            if (start == end) {
                return new ValueWithOffsets();
            }
            return new ValueWithOffsets(this.getContent().substring(start, end), this.getOffsetMap().subList(start, end));
        }
    }
}

