/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser;

import cc.redpen.RedPenException;
import cc.redpen.model.Document;
import cc.redpen.parser.LaTeXParser;
import cc.redpen.parser.MarkdownParser;
import cc.redpen.parser.PlainTextParser;
import cc.redpen.parser.PropertiesParser;
import cc.redpen.parser.SentenceExtractor;
import cc.redpen.parser.WikiParser;
import cc.redpen.parser.asciidoc.AsciiDocParser;
import cc.redpen.parser.rest.ReSTParser;
import cc.redpen.parser.review.ReVIEWParser;
import cc.redpen.tokenizer.RedPenTokenizer;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface DocumentParser {
    public static final DocumentParser PLAIN = new PlainTextParser();
    public static final DocumentParser WIKI = new WikiParser();
    public static final DocumentParser MARKDOWN = new MarkdownParser();
    public static final DocumentParser LATEX = new LaTeXParser();
    public static final DocumentParser ASCIIDOC = new AsciiDocParser();
    public static final DocumentParser PROPERTIES = new PropertiesParser();
    public static final DocumentParser REVIEW = new ReVIEWParser();
    public static final DocumentParser REST = new ReSTParser();
    public static final Map<String, DocumentParser> PARSER_MAP = Collections.unmodifiableMap(new HashMap<String, DocumentParser>(){
        {
            this.put("PLAIN", PLAIN);
            this.put("WIKI", WIKI);
            this.put("MARKDOWN", MARKDOWN);
            this.put("LATEX", LATEX);
            this.put("ASCIIDOC", ASCIIDOC);
            this.put("PROPERTIES", PROPERTIES);
            this.put("REVIEW", REVIEW);
            this.put("REST", REST);
        }
    });

    public Document parse(InputStream var1, SentenceExtractor var2, RedPenTokenizer var3) throws RedPenException;

    public Document parse(String var1, SentenceExtractor var2, RedPenTokenizer var3) throws RedPenException;

    public Document parse(File var1, SentenceExtractor var2, RedPenTokenizer var3) throws RedPenException;

    public static DocumentParser of(String parserType) {
        DocumentParser parser = PARSER_MAP.get(parserType.toUpperCase());
        if (parser == null) {
            throw new IllegalArgumentException("no such parser for :" + parserType);
        }
        return parser;
    }
}

