/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser;

import cc.redpen.RedPenException;
import cc.redpen.model.Document;
import cc.redpen.model.Section;
import cc.redpen.model.Sentence;
import cc.redpen.parser.BaseDocumentParser;
import cc.redpen.parser.PreprocessingReader;
import cc.redpen.parser.SentenceExtractor;
import cc.redpen.parser.latex.LaTeXProcessor;
import cc.redpen.tokenizer.RedPenTokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;

class LaTeXParser
extends BaseDocumentParser {
    LaTeXParser() {
    }

    @Override
    public Document parse(InputStream inputStream, Optional<String> fileName, SentenceExtractor sentenceExtractor, RedPenTokenizer tokenizer) throws RedPenException {
        Document.DocumentBuilder documentBuilder = Document.builder(tokenizer);
        fileName.ifPresent(documentBuilder::setFileName);
        StringBuilder sb = new StringBuilder();
        int charCount = 0;
        ArrayList<Integer> lineList = new ArrayList<Integer>();
        PreprocessingReader br = this.createReader(inputStream);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
                lineList.add(charCount += line.length() + 1);
            }
        }
        catch (IOException e) {
            throw new RedPenException(e);
        }
        ArrayList<Sentence> headers = new ArrayList<Sentence>();
        headers.add(new Sentence("", 0));
        documentBuilder.appendSection(new Section(0, headers));
        new LaTeXProcessor().parse(sb.toString().toCharArray(), documentBuilder, sentenceExtractor);
        documentBuilder.setPreprocessorRules(br.getPreprocessorRules());
        return documentBuilder.build();
    }
}

