/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser;

import cc.redpen.RedPenException;
import cc.redpen.model.Document;
import cc.redpen.parser.BaseDocumentParser;
import cc.redpen.parser.PreprocessingReader;
import cc.redpen.parser.SentenceExtractor;
import cc.redpen.parser.markdown.ToFileContentSerializer;
import cc.redpen.tokenizer.RedPenTokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import org.pegdown.ParsingTimeoutException;
import org.pegdown.PegDownProcessor;
import org.pegdown.ast.RootNode;

class MarkdownParser
extends BaseDocumentParser {
    private PegDownProcessor pegDownProcessor = new PegDownProcessor(184);

    MarkdownParser() {
    }

    @Override
    public Document parse(InputStream inputStream, Optional<String> fileName, SentenceExtractor sentenceExtractor, RedPenTokenizer tokenizer) throws RedPenException {
        Document.DocumentBuilder documentBuilder = Document.builder(tokenizer);
        fileName.ifPresent(documentBuilder::setFileName);
        StringBuilder fullText = new StringBuilder();
        ArrayList<Integer> lineLengths = new ArrayList<Integer>();
        try (PreprocessingReader br = this.createReader(inputStream);){
            String line;
            int charCount = 0;
            while ((line = br.readLine()) != null) {
                fullText.append(line).append("\n");
                lineLengths.add(charCount += line.length() + 1);
            }
            documentBuilder.setPreprocessorRules(br.getPreprocessorRules());
        }
        catch (IOException e) {
            throw new RedPenException(e);
        }
        try {
            RootNode rootNode = this.pegDownProcessor.parseMarkdown(fullText.toString().toCharArray());
            ToFileContentSerializer serializer = new ToFileContentSerializer(documentBuilder, lineLengths, sentenceExtractor);
            serializer.toFileContent(rootNode);
        }
        catch (ParsingTimeoutException e) {
            throw new RedPenException("Failed to parse timeout: ", (Exception)((Object)e));
        }
        return documentBuilder.build();
    }
}

