/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser;

import cc.redpen.RedPenException;
import cc.redpen.model.Document;
import cc.redpen.model.Sentence;
import cc.redpen.parser.BaseDocumentParser;
import cc.redpen.parser.LineOffset;
import cc.redpen.parser.PreprocessingReader;
import cc.redpen.parser.SentenceExtractor;
import cc.redpen.tokenizer.RedPenTokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;

public final class PlainTextParser
extends BaseDocumentParser
implements Serializable {
    private static final long serialVersionUID = -4343255148183552844L;

    PlainTextParser() {
    }

    @Override
    public Document parse(InputStream is, Optional<String> fileName, SentenceExtractor sentenceExtractor, RedPenTokenizer tokenizer) throws RedPenException {
        Document.DocumentBuilder documentBuilder = Document.builder(tokenizer);
        fileName.ifPresent(documentBuilder::setFileName);
        ArrayList<Sentence> headers = new ArrayList<Sentence>();
        headers.add(new Sentence("", 0));
        documentBuilder.addSection(0, headers);
        documentBuilder.addParagraph();
        PreprocessingReader br = this.createReader(is);
        int linesRead = 0;
        int startLine = 1;
        String paragraph = "";
        try {
            String line;
            while ((line = br.readLine()) != null) {
                ++linesRead;
                if (line.equals("")) {
                    if (!paragraph.isEmpty()) {
                        this.extractSentences(startLine, paragraph, sentenceExtractor, documentBuilder);
                    }
                    startLine = linesRead + 1;
                    documentBuilder.addParagraph();
                    paragraph = "";
                    continue;
                }
                paragraph = paragraph + (paragraph.isEmpty() ? "" : "\n") + line;
            }
        }
        catch (IOException e) {
            throw new RedPenException(e);
        }
        if (!paragraph.isEmpty()) {
            this.extractSentences(startLine, paragraph, sentenceExtractor, documentBuilder);
        }
        documentBuilder.setPreprocessorRules(br.getPreprocessorRules());
        return documentBuilder.build();
    }

    public static LineOffset addSentence(LineOffset lineOffset, String rawSentenceText, SentenceExtractor sentenceExtractor, Document.DocumentBuilder builder) {
        char ch;
        int i;
        int lineNum = lineOffset.lineNum;
        int offset = lineOffset.offset;
        int sentenceStartLineNum = lineNum;
        int sentenceStartLineOffset = offset;
        ArrayList<LineOffset> offsetMap = new ArrayList<LineOffset>();
        String normalizedSentence = "";
        for (i = 0; i < rawSentenceText.length() && (ch = rawSentenceText.charAt(i)) == '\n'; ++i) {
            ++sentenceStartLineNum;
            ++lineNum;
            sentenceStartLineOffset = 0;
            offset = 0;
        }
        while (i < rawSentenceText.length()) {
            ch = rawSentenceText.charAt(i);
            if (ch == '\n') {
                if (!sentenceExtractor.getBrokenLineSeparator().isEmpty()) {
                    offsetMap.add(new LineOffset(lineNum, offset));
                    normalizedSentence = normalizedSentence + sentenceExtractor.getBrokenLineSeparator();
                }
                ++lineNum;
                offset = 0;
            } else {
                normalizedSentence = normalizedSentence + ch;
                offsetMap.add(new LineOffset(lineNum, offset));
                ++offset;
            }
            ++i;
        }
        Sentence sentence = new Sentence(normalizedSentence, sentenceStartLineNum, sentenceStartLineOffset);
        sentence.setOffsetMap(offsetMap);
        builder.addSentence(sentence);
        return new LineOffset(lineNum, offset);
    }

    private void extractSentences(int lineNum, String paragraphText, SentenceExtractor sentenceExtractor, Document.DocumentBuilder builder) {
        int periodPosition = sentenceExtractor.getSentenceEndPosition(paragraphText);
        LineOffset lineOffset = new LineOffset(lineNum, 0);
        if (periodPosition != -1) {
            do {
                lineOffset = PlainTextParser.addSentence(lineOffset, paragraphText.substring(0, periodPosition + 1), sentenceExtractor, builder);
            } while ((periodPosition = sentenceExtractor.getSentenceEndPosition(paragraphText = paragraphText.substring(periodPosition + 1, paragraphText.length()))) != -1);
            if (!paragraphText.isEmpty()) {
                PlainTextParser.addSentence(lineOffset, paragraphText, sentenceExtractor, builder);
            }
            return;
        }
        PlainTextParser.addSentence(lineOffset, paragraphText, sentenceExtractor, builder);
    }

    public String toString() {
        return "PlainTextParser{}";
    }
}

