/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser;

import cc.redpen.parser.DocumentParser;
import cc.redpen.parser.LaTeXParser;
import cc.redpen.parser.MarkdownParser;
import cc.redpen.parser.PreprocessorRule;
import cc.redpen.parser.asciidoc.AsciiDocParser;
import cc.redpen.parser.rest.ReSTParser;
import cc.redpen.parser.review.ReVIEWParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;

public class PreprocessingReader
implements AutoCloseable {
    private BufferedReader reader;
    private Set<PreprocessorRule> preprocessorRules = new HashSet<PreprocessorRule>();
    private int lineNumber = 0;
    private PreprocessorRule lastRule = null;
    private DocumentParser parser = null;

    public PreprocessingReader(Reader reader, DocumentParser parser) {
        this.reader = new BufferedReader(reader);
        this.parser = parser;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public String readLine() throws IOException {
        String line = this.reader.readLine();
        ++this.lineNumber;
        if (line == null) {
            return line;
        }
        String ruleText = line;
        if (this.parser instanceof AsciiDocParser) {
            if (ruleText.toLowerCase().startsWith("[suppress")) {
                this.addAsciiDocAttributeSuppressRule(ruleText);
                return "";
            }
        } else if (this.parser instanceof MarkdownParser) {
            if (ruleText.matches("^ *<!-- *@suppress (.*)-->")) {
                ruleText = line.replaceAll("^ *<!--", "").replaceAll("-->", "").trim();
                this.addCommentSuppressRule(ruleText);
            }
        } else if (this.parser instanceof ReVIEWParser) {
            if (ruleText.matches("^#@# *@suppress(.*)")) {
                ruleText = line.replaceAll("^#@#", "").trim();
                this.addCommentSuppressRule(ruleText);
            }
        } else if (this.parser instanceof LaTeXParser) {
            if (ruleText.matches("^% *@suppress(.*)")) {
                ruleText = line.replaceAll("^%", "").trim();
                this.addCommentSuppressRule(ruleText);
            }
        } else if (this.parser instanceof ReSTParser && ruleText.matches("[.][.] *@suppress(.*)")) {
            ruleText = line.replaceAll("[.][.]", "").trim();
            this.addCommentSuppressRule(ruleText, 3);
        }
        return line;
    }

    private void addAsciiDocAttributeSuppressRule(String ruleString) {
        PreprocessorRule rule = new PreprocessorRule(PreprocessorRule.RuleType.SUPPRESS, this.lineNumber);
        if (this.lastRule != null) {
            this.lastRule.setLineNumberLimit(this.lineNumber);
        }
        this.lastRule = rule;
        String[] parts = ruleString.split("=");
        if (parts.length > 1) {
            String[] parameters;
            for (String parameter : parameters = parts[1].replaceAll("[\"'\\]]", "").split(" ")) {
                if (parameter.isEmpty()) continue;
                rule.addParameter(parameter);
            }
        }
        this.preprocessorRules.add(rule);
    }

    private void addCommentSuppressRule(String ruleString) {
        this.addCommentSuppressRule(ruleString, 0);
    }

    private void addCommentSuppressRule(String ruleString, int gap) {
        PreprocessorRule rule = new PreprocessorRule(PreprocessorRule.RuleType.SUPPRESS, this.lineNumber + gap);
        if (this.lastRule != null) {
            this.lastRule.setLineNumberLimit(this.lineNumber);
        }
        this.lastRule = rule;
        String[] parts = ruleString.split(" ");
        if (parts.length > 1) {
            for (int i = 1; i < parts.length; ++i) {
                if (parts[i].isEmpty()) continue;
                rule.addParameter(parts[i]);
            }
        }
        this.preprocessorRules.add(rule);
    }

    public Set<PreprocessorRule> getPreprocessorRules() {
        return this.preprocessorRules;
    }
}

