/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser;

import cc.redpen.model.Document;
import cc.redpen.model.ListBlock;
import cc.redpen.model.ListElement;
import cc.redpen.model.Paragraph;
import cc.redpen.model.Section;
import cc.redpen.model.Sentence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PreprocessorRule {
    private int lineNumber = 0;
    private int lineNumberLimit = 0;
    private List<String> parameters = new ArrayList<String>();
    private RuleType ruleType;

    public PreprocessorRule(RuleType ruleType, int lineNumber) {
        this.ruleType = ruleType;
        this.lineNumber = lineNumber + 1;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getLineNumberLimit() {
        return this.lineNumberLimit;
    }

    public void setLineNumberLimit(int lineNumberLimit) {
        this.lineNumberLimit = lineNumberLimit;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void addParameter(String parameter) {
        this.parameters.add(parameter.toLowerCase());
    }

    public boolean isTriggeredBy(Document document, int errorLineNumber, String validatorName) {
        if ((this.lineNumberLimit < this.lineNumber || errorLineNumber < this.lineNumberLimit) && (this.parameters.isEmpty() || this.parameters.contains(validatorName.toLowerCase().replaceAll("\\.js$", "")))) {
            for (Section section : document) {
                ArrayList<Sentence> allBlockSentences = new ArrayList<Sentence>();
                allBlockSentences.addAll(section.getHeaderContents());
                for (Paragraph paragraph : section.getParagraphs()) {
                    allBlockSentences.addAll(paragraph.getSentences());
                }
                for (ListBlock listBlock : section.getListBlocks()) {
                    for (ListElement element : listBlock.getListElements()) {
                        allBlockSentences.addAll(element.getSentences());
                    }
                }
                if (!this.isInsideSentences(allBlockSentences, this.lineNumber, errorLineNumber)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInsideSentences(Collection<Sentence> sentences, int ruleLineNumber, int errorLineNumber) {
        if (ruleLineNumber > errorLineNumber) {
            return false;
        }
        int startLine = Integer.MAX_VALUE;
        int endLine = 0;
        for (Sentence sentence : sentences) {
            startLine = Math.min(startLine, sentence.getLineNumber());
            endLine = Math.max(endLine, sentence.getLineNumber());
        }
        return startLine <= ruleLineNumber && endLine >= ruleLineNumber && startLine <= errorLineNumber && endLine >= errorLineNumber;
    }

    public static enum RuleType {
        SUPPRESS;

    }
}

