/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser;

import cc.redpen.RedPenException;
import cc.redpen.model.Document;
import cc.redpen.model.Sentence;
import cc.redpen.parser.BaseDocumentParser;
import cc.redpen.parser.LineOffset;
import cc.redpen.parser.PreprocessingReader;
import cc.redpen.parser.SentenceExtractor;
import cc.redpen.tokenizer.RedPenTokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

class PropertiesParser
extends BaseDocumentParser {
    PropertiesParser() {
    }

    @Override
    public Document parse(InputStream inputStream, Optional<String> fileName, SentenceExtractor sentenceExtractor, RedPenTokenizer tokenizer) throws RedPenException {
        Document.DocumentBuilder builder = Document.builder(tokenizer);
        fileName.ifPresent(builder::setFileName);
        try (PreprocessingReader reader = this.createReader(inputStream);){
            String line;
            AtomicInteger lineNum = new AtomicInteger(0);
            while ((line = reader.readLine()) != null) {
                lineNum.incrementAndGet();
                int keyStart = this.skipWhitespace(line, 0);
                if (keyStart == line.length()) continue;
                int valueStart = this.valueOffset(line, keyStart);
                this.addSentences(builder, sentenceExtractor, this.section(line, lineNum, valueStart, reader));
            }
            builder.setPreprocessorRules(reader.getPreprocessorRules());
        }
        catch (IOException e) {
            throw new RedPenException(e);
        }
        return builder.build();
    }

    private void addSentences(Document.DocumentBuilder builder, SentenceExtractor sentenceExtractor, BaseDocumentParser.ValueWithOffsets value) {
        if (value == null) {
            return;
        }
        String text = value.getContent();
        List<LineOffset> offsets = value.getOffsetMap();
        builder.addSection(0).addParagraph();
        while (text.length() > 0) {
            int end = sentenceExtractor.getSentenceEndPosition(text) + 1;
            if (end == 0) {
                end = text.length();
            }
            builder.addSentence(new Sentence(text.substring(0, end), offsets.subList(0, end), Collections.emptyList()));
            text = text.substring(end, text.length());
            offsets = offsets.subList(end, offsets.size());
        }
    }

    private BaseDocumentParser.ValueWithOffsets section(String line, AtomicInteger lineNum, int valueStart, PreprocessingReader reader) throws IOException {
        int length = line.length();
        StringBuilder value = new StringBuilder(length);
        ArrayList<LineOffset> offsets = new ArrayList<LineOffset>(length);
        for (int i = valueStart; i < length; ++i) {
            int c = line.charAt(i);
            int offset = i++;
            if (c == 92) {
                if (i == length) {
                    lineNum.incrementAndGet();
                    line = reader.readLine();
                    valueStart = this.skipWhitespace(line, 0);
                    offsets.add(new LineOffset(lineNum.get(), valueStart));
                    BaseDocumentParser.ValueWithOffsets nextLine = this.section(line, lineNum, valueStart, reader);
                    if (nextLine == null) continue;
                    value.append('\n').append(nextLine.getContent());
                    offsets.addAll(nextLine.getOffsetMap());
                    continue;
                }
                c = line.charAt(i);
                if (c == 110) {
                    c = 10;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 102) {
                    c = 12;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 117) {
                    String code = line.substring(i + 1, i + 5);
                    c = (char)Integer.parseInt(code, 16);
                    i += 4;
                }
            }
            value.append((char)c);
            offsets.add(new LineOffset(lineNum.get(), offset));
        }
        return value.length() == 0 ? null : new BaseDocumentParser.ValueWithOffsets(value.toString(), offsets);
    }

    private int valueOffset(String line, int start) {
        int result = -1;
        for (int i = start; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (Character.isWhitespace(c)) {
                result = i;
                continue;
            }
            if (c == ':' || c == '=' || c == '#' || c == '!') {
                result = i;
                break;
            }
            if (result >= 0) break;
        }
        return this.skipWhitespace(line, result + 1);
    }
}

