/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser;

import cc.redpen.config.Configuration;
import cc.redpen.config.SymbolTable;
import cc.redpen.config.SymbolType;
import cc.redpen.util.EndOfSentenceDetector;
import cc.redpen.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentenceExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(SentenceExtractor.class);
    private Pattern fullStopPattern;
    private char[] fullStopList;
    private char[] rightQuotationList;
    private static final List<String> WHITE_WORDS = SentenceExtractor.generateUmList("Mr.", "Mrs.", "Dr.", "genn.ai", "Co., Ltd.", "Miss.", "a.m.", "U.S.A.", "Jan.", "Feb.", "Mar.", "Apr.", "May.", "Jun.", "Jul.", "Aug.", "Sep.", "Oct.", "Nov.", "Dec.", "Feb.", "B.C", "A.D.");
    private EndOfSentenceDetector endOfSentenceDetector;
    private SymbolTable symbolTable = null;

    SentenceExtractor(char ... fullStopList) {
        this(fullStopList, SentenceExtractor.extractRightQuotations(Configuration.builder().build().getSymbolTable()));
    }

    public SentenceExtractor(SymbolTable symbolTable) {
        this(SentenceExtractor.extractPeriods(symbolTable), SentenceExtractor.extractRightQuotations(symbolTable));
        this.symbolTable = symbolTable;
    }

    SentenceExtractor(char[] fullStopList, char[] rightQuotationList) {
        this.fullStopList = fullStopList;
        this.rightQuotationList = rightQuotationList;
        this.fullStopPattern = this.constructEndSentencePattern();
        this.endOfSentenceDetector = new EndOfSentenceDetector(this.fullStopPattern, WHITE_WORDS);
    }

    private static char[] extractPeriods(SymbolTable symbolTable) {
        char[] periods = new char[]{symbolTable.getValueOrFallbackToDefault(SymbolType.FULL_STOP), symbolTable.getValueOrFallbackToDefault(SymbolType.QUESTION_MARK), symbolTable.getValueOrFallbackToDefault(SymbolType.EXCLAMATION_MARK)};
        LOG.info("\"" + Arrays.toString(periods) + "\" are added as a end of sentence characters");
        return periods;
    }

    private static char[] extractRightQuotations(SymbolTable symbolTable) {
        char[] rightQuotations = new char[]{symbolTable.getValueOrFallbackToDefault(SymbolType.RIGHT_SINGLE_QUOTATION_MARK), symbolTable.getValueOrFallbackToDefault(SymbolType.RIGHT_DOUBLE_QUOTATION_MARK)};
        LOG.info("\"" + Arrays.toString(rightQuotations) + "\" are added as a right quotation characters");
        return rightQuotations;
    }

    private void generateSimplePattern(char[] endCharacters, StringBuilder patternString) {
        patternString.append("[");
        for (char endChar : endCharacters) {
            patternString.append(SentenceExtractor.handleSpecialCharacter(endChar));
        }
        patternString.append("]");
    }

    private static String handleSpecialCharacter(char endChar) {
        if (endChar == '.') {
            return "\\.";
        }
        if (endChar == '?') {
            return "\\?";
        }
        if (endChar == '!') {
            return "\\!";
        }
        return String.valueOf(endChar);
    }

    private static <E> List<E> generateUmList(E ... args) {
        return new ArrayList<E>(Arrays.asList(args));
    }

    public int extract(String line, List<Pair<Integer, Integer>> sentencePositions) {
        int startPosition = 0;
        int periodPosition = this.endOfSentenceDetector.getSentenceEndPosition(line, 0);
        while (periodPosition >= 0) {
            sentencePositions.add(new Pair<Integer, Integer>(startPosition, periodPosition + 1));
            startPosition = periodPosition + 1;
            periodPosition = this.endOfSentenceDetector.getSentenceEndPosition(line, startPosition);
        }
        return startPosition;
    }

    public int getSentenceEndPosition(String str) {
        return this.endOfSentenceDetector.getSentenceEndPosition(str, 0);
    }

    public String getBrokenLineSeparator() {
        return this.symbolTable != null && this.symbolTable.getLang().equals("ja") ? "" : " ";
    }

    Pattern constructEndSentencePattern() {
        if (this.fullStopList == null || this.fullStopList.length == 0) {
            throw new IllegalArgumentException("No end character is specified");
        }
        StringBuilder patternString = new StringBuilder();
        this.generateSimplePattern(this.fullStopList, patternString);
        patternString.append("[");
        for (char rightQuotation : this.rightQuotationList) {
            patternString.append(rightQuotation);
        }
        patternString.append("]?");
        return Pattern.compile(patternString.toString());
    }
}

