/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser;

import cc.redpen.RedPenException;
import cc.redpen.model.Document;
import cc.redpen.model.Section;
import cc.redpen.model.Sentence;
import cc.redpen.parser.BaseDocumentParser;
import cc.redpen.parser.LineOffset;
import cc.redpen.parser.ParserUtils;
import cc.redpen.parser.PreprocessingReader;
import cc.redpen.parser.SentenceExtractor;
import cc.redpen.tokenizer.RedPenTokenizer;
import cc.redpen.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WikiParser
extends BaseDocumentParser {
    private static final Logger LOG = LoggerFactory.getLogger(WikiParser.class);
    private static final Pattern HEADER_PATTERN = Pattern.compile("^h([1-6])\\. (.*)$");
    private static final Pattern LIST_PATTERN = Pattern.compile("^(-+) (.*)$");
    private static final Pattern NUMBERED_LIST_PATTERN = Pattern.compile("^(#+) (.*)$");
    private static final Pattern LINK_PATTERN = Pattern.compile("\\[\\[\\s*(.*?)(?:\\s*\\|\\s*(.*?)(?:\\s*\\|.*?)?)?\\s*\\]\\]");
    private static final Pattern BEGIN_COMMENT_PATTERN = Pattern.compile("^\\s*\\[!--");
    private static final Pattern END_COMMENT_PATTERN = Pattern.compile("--\\]\\s*$");
    private static final Pattern ITALIC_PATTERN = Pattern.compile("//(.+?)//");
    private static final Pattern UNDERLINE_PATTERN = Pattern.compile("__(.+?)__");
    private static final Pattern BOLD_PATTERN = Pattern.compile("\\*\\*(.+?)\\*\\*");
    private static final Pattern STRIKETHROUGH_PATTERN = Pattern.compile("--(.+?)--");
    private static final Pattern[] INLINE_PATTERNS = new Pattern[]{ITALIC_PATTERN, BOLD_PATTERN, UNDERLINE_PATTERN, STRIKETHROUGH_PATTERN};

    WikiParser() {
    }

    private static boolean check(Pattern p, String target, int lineNum, List<BaseDocumentParser.ValueWithOffsets> groups) {
        Matcher m = p.matcher(target);
        if (m.matches()) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                groups.add(new BaseDocumentParser.ValueWithOffsets(m.group(i), WikiParser.offsets(lineNum, IntStream.range(m.start(i), m.end(i)))));
            }
            return true;
        }
        return false;
    }

    @Override
    public Document parse(InputStream is, Optional<String> filename, SentenceExtractor sentenceExtractor, RedPenTokenizer tokenizer) throws RedPenException {
        Document.DocumentBuilder documentBuilder = Document.builder(tokenizer);
        filename.ifPresent(documentBuilder::setFileName);
        ArrayList<Sentence> headers = new ArrayList<Sentence>();
        headers.add(new Sentence("", 1));
        documentBuilder.addSection(0, headers);
        LinePattern currentPattern = LinePattern.VOID;
        int lineNum = 1;
        BaseDocumentParser.ValueWithOffsets remain = new BaseDocumentParser.ValueWithOffsets();
        PreprocessingReader br = this.createReader(is);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                LinePattern prevPattern = currentPattern;
                ArrayList<BaseDocumentParser.ValueWithOffsets> groups = new ArrayList<BaseDocumentParser.ValueWithOffsets>();
                if (currentPattern == LinePattern.COMMENT && WikiParser.check(END_COMMENT_PATTERN, line, lineNum, groups)) {
                    currentPattern = LinePattern.VOID;
                } else if (WikiParser.check(HEADER_PATTERN, line, lineNum, groups)) {
                    currentPattern = LinePattern.HEADER;
                    this.appendSection(groups, sentenceExtractor, documentBuilder);
                } else if (WikiParser.check(LIST_PATTERN, line, lineNum, groups)) {
                    currentPattern = LinePattern.LIST;
                    this.appendListElement(prevPattern, groups, sentenceExtractor, documentBuilder);
                } else if (WikiParser.check(NUMBERED_LIST_PATTERN, line, lineNum, groups)) {
                    currentPattern = LinePattern.LIST;
                    this.appendListElement(prevPattern, groups, sentenceExtractor, documentBuilder);
                } else if (WikiParser.check(BEGIN_COMMENT_PATTERN, line, lineNum, groups) && !WikiParser.check(END_COMMENT_PATTERN, line, lineNum, groups)) {
                    currentPattern = LinePattern.COMMENT;
                } else if (line.equals("")) {
                    documentBuilder.addParagraph();
                } else {
                    currentPattern = LinePattern.SENTENCE;
                    remain = this.appendSentencesIntoSection(remain.append(line, WikiParser.offsets(lineNum, IntStream.range(0, line.length()))), sentenceExtractor, documentBuilder);
                }
                ++lineNum;
            }
        }
        catch (IOException e) {
            throw new RedPenException(e);
        }
        if (!remain.isEmpty()) {
            this.appendLastSentence(remain, documentBuilder);
        }
        documentBuilder.setPreprocessorRules(br.getPreprocessorRules());
        return documentBuilder.build();
    }

    private void appendListElement(LinePattern prevPattern, List<BaseDocumentParser.ValueWithOffsets> head, SentenceExtractor sentenceExtractor, Document.DocumentBuilder builder) {
        if (prevPattern != LinePattern.LIST) {
            builder.addListBlock();
        }
        ArrayList<Sentence> outputSentences = new ArrayList<Sentence>();
        BaseDocumentParser.ValueWithOffsets remainSentence = this.obtainSentences(head.get(1), outputSentences, sentenceExtractor);
        builder.addListElement(this.extractListLevel(head.get(0).getContent()), outputSentences);
        if (!remainSentence.isEmpty()) {
            outputSentences.add(new Sentence(remainSentence.getContent(), remainSentence.getOffsetMap(), new ArrayList<String>()));
        }
    }

    private Section appendSection(List<BaseDocumentParser.ValueWithOffsets> head, SentenceExtractor sentenceExtractor, Document.DocumentBuilder builder) {
        Integer level = Integer.valueOf(head.get(0).getContent());
        ArrayList<Sentence> outputSentences = new ArrayList<Sentence>();
        BaseDocumentParser.ValueWithOffsets remainHeader = this.obtainSentences(head.get(1), outputSentences, sentenceExtractor);
        if (!remainHeader.isEmpty()) {
            outputSentences.add(new Sentence(remainHeader.getContent(), remainHeader.getOffsetMap(), new ArrayList<String>()));
        }
        if (outputSentences.size() > 0) {
            ((Sentence)outputSentences.get(0)).setIsFirstSentence(true);
        }
        Section currentSection = builder.getLastSection();
        builder.addSection(level, outputSentences);
        Section tmpSection = builder.getLastSection();
        if (!ParserUtils.addChild(currentSection, tmpSection)) {
            LOG.warn("Failed to add parent for a Section: " + tmpSection.getHeaderContents().get(0));
        }
        currentSection = tmpSection;
        return currentSection;
    }

    private void appendLastSentence(BaseDocumentParser.ValueWithOffsets remain, Document.DocumentBuilder builder) {
        Sentence sentence = new Sentence(remain.getContent(), remain.getOffsetMap(), new ArrayList<String>());
        this.parseSentence(sentence);
        builder.addSentence(sentence);
    }

    private void parseSentence(Sentence sentence) {
        this.extractLinks(sentence);
        this.removeTags(sentence);
    }

    private void removeTags(Sentence sentence) {
        String content = sentence.getContent();
        ArrayList<LineOffset> offsets = new ArrayList<LineOffset>(sentence.getOffsetMap());
        for (Pattern inlinePattern : INLINE_PATTERNS) {
            Matcher m = inlinePattern.matcher(content);
            StringBuffer sb = new StringBuffer();
            ArrayList o = new ArrayList(sentence.getOffsetMap().size());
            int lastPos = 0;
            while (m.find()) {
                m.appendReplacement(sb, "$1");
                o.addAll(offsets.subList(lastPos, m.start()));
                o.addAll(offsets.subList(m.start(1), m.end(1)));
                lastPos = m.end();
            }
            m.appendTail(sb);
            o.addAll(offsets.subList(lastPos, offsets.size()));
            content = sb.toString();
            offsets = o;
        }
        sentence.setContent(content);
        sentence.setOffsetMap(offsets);
    }

    private void extractLinks(Sentence sentence) {
        StringBuilder modContent = new StringBuilder();
        ArrayList<LineOffset> modOffsets = new ArrayList<LineOffset>();
        int start = 0;
        Matcher m = LINK_PATTERN.matcher(sentence.getContent());
        while (m.find()) {
            modContent.append(sentence.getContent().substring(start, m.start()));
            modOffsets.addAll(sentence.getOffsetMap().subList(start, m.start()));
            modContent.append(sentence.getContent().substring(m.start(1), m.end(1)));
            modOffsets.addAll(sentence.getOffsetMap().subList(m.start(1), m.end(1)));
            if (m.start(2) < 0) {
                sentence.addLink(sentence.getContent().substring(m.start(1), m.end(1)));
            } else {
                sentence.addLink(sentence.getContent().substring(m.start(2), m.end(2)));
            }
            start = m.end();
        }
        if (start > 0) {
            modContent.append(sentence.getContent().substring(start, sentence.getContent().length()));
            modOffsets.addAll(sentence.getOffsetMap().subList(start, sentence.getContent().length()));
            sentence.setContent(modContent.toString());
            sentence.setOffsetMap(modOffsets);
        }
    }

    private BaseDocumentParser.ValueWithOffsets obtainSentences(BaseDocumentParser.ValueWithOffsets value, List<Sentence> outputSentences, SentenceExtractor sentenceExtractor) {
        ArrayList<Pair<Integer, Integer>> positions = new ArrayList<Pair<Integer, Integer>>();
        int lastPosition = sentenceExtractor.extract(value.getContent(), positions);
        for (Pair pair : positions) {
            outputSentences.add(value.extract((Integer)pair.first, (Integer)pair.second));
        }
        outputSentences.forEach(this::parseSentence);
        return value.extract(lastPosition, value.getContent().length());
    }

    private BaseDocumentParser.ValueWithOffsets appendSentencesIntoSection(BaseDocumentParser.ValueWithOffsets value, SentenceExtractor sentenceExtractor, Document.DocumentBuilder builder) {
        ArrayList<Sentence> outputSentences = new ArrayList<Sentence>();
        BaseDocumentParser.ValueWithOffsets newRemain = this.obtainSentences(value, outputSentences, sentenceExtractor);
        outputSentences.forEach(builder::addSentence);
        return newRemain;
    }

    private static List<LineOffset> offsets(int lineNum, IntStream stream) {
        return stream.mapToObj(p -> new LineOffset(lineNum, p)).collect(Collectors.toList());
    }

    private int extractListLevel(String listPrefix) {
        return listPrefix.length();
    }

    static enum LinePattern {
        SENTENCE,
        LIST,
        NUM_LIST,
        VOID,
        HEADER,
        COMMENT;

    }
}

