/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser.asciidoc;

import cc.redpen.parser.PreprocessingReader;
import cc.redpen.parser.asciidoc.AsciiDocLine;
import cc.redpen.parser.common.Line;
import cc.redpen.parser.common.LineParser;
import cc.redpen.parser.common.Model;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciiDocParser
extends LineParser {
    private static final Logger LOG = LoggerFactory.getLogger(AsciiDocParser.class);
    private static final String[] MACROS = new String[]{"ifdef::", "ifndef::", "ifeval::", "endif::"};
    private static final String[] ADMONITIONS = new String[]{"NOTE: ", "TIP: ", "IMPORTANT: ", "CAUTION: ", "WARNING: "};
    private static final String[] EXTERNAL_LINK_PREFIXES = new String[]{"link:", "http://", "https://", "include:"};

    @Override
    protected void populateModel(Model model, InputStream io) {
        PreprocessingReader reader = this.createReader(io);
        int lineno = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                model.add(new AsciiDocLine(line, ++lineno));
            }
            reader.close();
            model.setPreprocessorRules(reader.getPreprocessorRules());
            State state = new State();
            model.rewind();
            while (model.isMore()) {
                this.processLine(model.getCurrentLine(), model, state);
                model.getNextLine();
            }
            this.processHeader(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("Exception when parsing AsciiDoc file", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("AsciiDoc parser model (X=erased line,[=block,section-listlevel-lineno,*=list item):\n" + model.toString());
        }
    }

    private boolean isListElement(Line line, Line nextLine) {
        int pos = 0;
        while (Character.isWhitespace(line.charAt(pos))) {
            ++pos;
        }
        if (".-*".indexOf(line.charAt(pos)) != -1) {
            char listMarker = line.charAt(pos);
            int level = 1;
            ++pos;
            while (line.charAt(pos) == listMarker) {
                ++pos;
                ++level;
            }
            if (Character.isWhitespace(line.charAt(pos))) {
                line.setListLevel(level);
                line.setListStart(true);
                line.erase(0, pos);
                while (Character.isWhitespace(line.charAt(pos))) {
                    line.erase(pos, 1);
                    ++pos;
                }
                return true;
            }
        }
        if (line.charAt(line.length() - 1) == ':' && line.charAt(line.length() - 2) == ':') {
            int level = 1;
            pos = line.length() - 3;
            while (pos > 0 && line.charAt(pos) == ':') {
                --pos;
                ++level;
            }
            nextLine.setListLevel(level);
            nextLine.setListStart(true);
            line.erase();
            return true;
        }
        int position = 0;
        position = line.getText().indexOf(":: ");
        if (position != -1) {
            line.setListLevel(1);
            line.setListStart(true);
            line.erase(0, position + 3);
            return true;
        }
        return false;
    }

    private void processHeader(Model model) {
        if (model.lineCount() > 1) {
            boolean haveHeader = false;
            if (model.getLine(1).charAt(0, true) == '=' && model.getLine(1).charAt(1, true) == ' ') {
                haveHeader = true;
            } else if (model.getLine(1).length() == model.getLine(2).length() && model.getLine(2).isAllSameCharacter() && model.getLine(2).charAt(0, true) == '=') {
                haveHeader = true;
            }
            if (haveHeader) {
                model.getLine(1).setSectionLevel(1);
                for (int i = 2; i <= model.lineCount() && (model.getLine(i).isErased() || !model.getLine(i).isEmpty()); ++i) {
                    model.getLine(i).erase();
                }
            }
        }
    }

    private void processLine(Line line, Model model, State state) {
        if (line.isErased()) {
            return;
        }
        LineParser.TargetLine target = new LineParser.TargetLine(line, model.getLine(line.getLineNo() - 1), model.getLine(line.getLineNo() + 1));
        if (state.inList && line.getListLevel() == 0) {
            line.setListLevel(target.previousLine.getListLevel());
        }
        if (state.inBlock) {
            if (line.isAllSameCharacter() && target.firstChar == state.blockMarker && line.length() == state.blockMarkerLength) {
                line.erase();
                line.setInBlock(true);
                state.inBlock = false;
                return;
            }
            if (line.length() >= 4 && target.firstChar == state.blockMarker && target.firstChar == '|' && target.secondChar == '=') {
                line.erase();
                line.setInBlock(true);
                state.inBlock = false;
                return;
            }
            line.setInBlock(true);
            if (state.eraseBlock) {
                line.erase();
                return;
            }
        }
        if (line.isAllSameCharacter() && line.length() == target.previousLine.length() && "=-~^+".indexOf(target.firstChar) != -1 && ". [".indexOf(target.previousLine.charAt(0, true)) == -1) {
            target.previousLine.setSectionLevel(1);
            line.erase();
            return;
        }
        if (line.isAllSameCharacter() && line.length() == 3 && line.charAt(0) == '\'') {
            line.erase();
            return;
        }
        if (line.isAllSameCharacter() && line.length() >= 4 && "_*".indexOf(target.firstChar) != -1) {
            line.erase();
            return;
        }
        if (!state.inBlock) {
            if (line.isAllSameCharacter() && line.length() == 3 && line.charAt(0) == '`') {
                state.inBlock = true;
                state.eraseBlock = true;
                state.blockMarker = target.firstChar;
                state.blockMarkerLength = line.length();
                line.setInBlock(true);
                line.erase();
                return;
            }
            if (line.isAllSameCharacter() && line.length() >= 4) {
                switch (target.firstChar) {
                    case '&': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case '=': {
                        state.inBlock = true;
                        state.eraseBlock = true;
                        state.blockMarker = target.firstChar;
                        state.blockMarkerLength = line.length();
                        line.setInBlock(true);
                        line.erase();
                        return;
                    }
                }
            }
            if (line.length() >= 4 && target.firstChar == '|' && target.secondChar == '=') {
                line.erase();
                state.inBlock = true;
                state.eraseBlock = true;
                state.blockMarker = (char)124;
                state.blockMarkerLength = 1;
                line.setInBlock(true);
                return;
            }
        }
        if (!state.inList && target.firstChar == ' ') {
            line.erase();
            return;
        }
        if (target.firstChar == '/' && target.secondChar == '/') {
            line.erase();
            return;
        }
        if (target.firstChar == '-' && target.secondChar == '-') {
            line.erase();
            return;
        }
        if (line.eraseEnclosure(":", ":", Line.EraseStyle.None) == 0) {
            line.erase();
            return;
        }
        if (line.eraseEnclosure("[", "]", Line.EraseStyle.None) == 0) {
            line.erase();
            return;
        }
        if (target.firstChar == '.' && " .".indexOf(target.secondChar) == -1) {
            line.erase(0, 1);
        }
        for (String prefix : EXTERNAL_LINK_PREFIXES) {
            line.eraseEnclosure(prefix, " ,[", Line.EraseStyle.CloseMarkerContainsDelimiters);
        }
        int position = line.eraseEnclosure("image:", " ,[", Line.EraseStyle.CloseMarkerContainsDelimiters);
        if (position != -1) {
            line.eraseEnclosure("[", "]", Line.EraseStyle.All);
        } else {
            line.eraseEnclosure("+++", "+++", Line.EraseStyle.All);
            line.eraseEnclosure("[[", "]]", Line.EraseStyle.All);
            line.eraseEnclosure("<<", ">>", Line.EraseStyle.PreserveLabel);
            line.eraseEnclosure("{", "}", Line.EraseStyle.Markers);
            line.eraseEnclosure("[", "]", Line.EraseStyle.Markers);
        }
        int headerIndent = 0;
        while (line.charAt(headerIndent) == '=') {
            ++headerIndent;
        }
        if (headerIndent > 0 && line.charAt(headerIndent) == ' ') {
            line.erase(0, headerIndent + 1);
            line.setSectionLevel(headerIndent);
        }
        if (!state.inBlock && this.isListElement(line, target.nextLine)) {
            state.inList = true;
        }
        if (line.charAt(line.length() - 1) == '+') {
            if (line.length() == 0) {
                line.erase();
            } else {
                line.erase(line.length() - 1, 1);
            }
        }
        if (state.inList && line.length() == 0) {
            state.inList = false;
            line.setListLevel(0);
        }
        for (String macro : MACROS) {
            if (!line.startsWith(macro)) continue;
            line.erase();
            break;
        }
        for (String admonition : ADMONITIONS) {
            if (!line.startsWith(admonition)) continue;
            line.erase(0, admonition.length());
            break;
        }
        this.eraseInlineMarkup(line);
    }

    private void eraseInlineMarkup(Line line) {
        line.eraseEnclosure("__", "__", Line.EraseStyle.Markers);
        line.eraseEnclosure("**", "**", Line.EraseStyle.Markers);
        line.eraseEnclosure("``", "``", Line.EraseStyle.Markers);
        line.eraseEnclosure("##", "##", Line.EraseStyle.Markers);
        line.eraseEnclosure("^", "^", Line.EraseStyle.Markers);
        line.eraseEnclosure("~", "~", Line.EraseStyle.Markers);
        line.eraseEnclosure("_", "_", Line.EraseStyle.InlineMarkup);
        line.eraseEnclosure("*", "*", Line.EraseStyle.InlineMarkup);
        line.eraseEnclosure("`", "`", Line.EraseStyle.InlineMarkup);
        line.eraseEnclosure("#", "#", Line.EraseStyle.InlineMarkup);
        line.erase("'`");
        line.erase("`'");
        line.erase("\"`");
        line.erase("`\"");
        line.erase("(C)");
        line.erase("(R)");
        line.erase("(TM)");
    }

    private class State {
        public boolean inBlock = false;
        public boolean inList = false;
        public boolean eraseBlock = true;
        public char blockMarker = '\u0000';
        public int blockMarkerLength = 0;

        private State() {
        }
    }
}

