/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser.common;

import java.util.ArrayList;
import java.util.List;

public class Line {
    static final char ESCAPED_CHARACTER_VALUE = '\u00f8';
    protected List<Integer> offsets = new ArrayList<Integer>();
    protected List<Character> characters = new ArrayList<Character>();
    protected String text;
    protected List<Boolean> valid = new ArrayList<Boolean>();
    protected List<Boolean> escaped = new ArrayList<Boolean>();
    protected boolean erased = false;
    protected int lineNo = 0;
    protected boolean allSameCharacter = false;
    protected boolean inBlock = false;
    protected int sectionLevel = 0;
    protected int listLevel = 0;
    protected boolean listStart = false;
    protected String inlineMarkupDelimiters = " ";

    public Line(String str, int lineNo) {
        this.lineNo = lineNo;
        this.text = str;
    }

    public void erase(int pos, int length) {
        if (pos >= 0 && pos < this.valid.size()) {
            for (int i = pos; i < this.valid.size() && i < pos + length; ++i) {
                this.valid.set(i, false);
            }
        }
    }

    public void erase() {
        for (int i = 0; i < this.valid.size(); ++i) {
            this.valid.set(i, false);
        }
        this.erased = true;
    }

    public void erase(String segment) {
        for (int i = 0; i < this.characters.size(); ++i) {
            boolean found = true;
            for (int j = 0; j < segment.length(); ++j) {
                if (this.charAt(j + i) == segment.charAt(j)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            this.erase(i, segment.length());
            i += segment.length();
        }
    }

    public int length() {
        return this.characters.size();
    }

    public char charAt(int i) {
        return this.charAt(i, false);
    }

    public char charAt(int i, boolean includeInvalid) {
        if (i >= 0 && i < this.characters.size()) {
            if (this.escaped.get(i).booleanValue()) {
                return '\u00f8';
            }
            if (includeInvalid || this.valid.get(i).booleanValue()) {
                return this.characters.get(i).charValue();
            }
        }
        return '\u0000';
    }

    public boolean startsWith(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (this.charAt(i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public char rawCharAt(int i) {
        if (i >= 0 && i < this.characters.size()) {
            return this.characters.get(i).charValue();
        }
        return ' ';
    }

    public boolean isValid(int i) {
        if (i >= 0 && i < this.characters.size()) {
            return this.valid.get(i);
        }
        return false;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.characters.size(); ++i) {
            if (Character.isWhitespace(this.characters.get(i).charValue()) || !this.valid.get(i).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public int getOffset(int i) {
        if (i >= 0) {
            if (i < this.offsets.size()) {
                return this.offsets.get(i);
            }
            return this.offsets.size();
        }
        return 0;
    }

    public boolean isAllSameCharacter() {
        return this.allSameCharacter;
    }

    public boolean isErased() {
        return this.erased;
    }

    public boolean isInBlock() {
        return this.inBlock;
    }

    public boolean isListStart() {
        return this.listStart;
    }

    public int getListLevel() {
        return this.listLevel;
    }

    public int getSectionLevel() {
        return this.sectionLevel;
    }

    public void setInBlock(boolean inBlock) {
        this.inBlock = inBlock;
    }

    public void setSectionLevel(int newSectionLevel) {
        this.sectionLevel = newSectionLevel;
    }

    public void setListLevel(int newListLevel) {
        this.listLevel = newListLevel;
    }

    public void setListStart(boolean listStart) {
        this.listStart = listStart;
    }

    public String getText() {
        return this.text;
    }

    public int eraseEnclosure(String open, String close, EraseStyle eraseStyle) {
        boolean inEnclosure = false;
        int firstEnclosurePosition = -1;
        int lastCommaPosition = -1;
        int enclosureStart = 0;
        for (int i = 0; i < this.length(); ++i) {
            int j;
            if (!this.valid.get(i).booleanValue()) continue;
            if (!inEnclosure) {
                boolean foundOpen = true;
                for (j = 0; j < open.length(); ++j) {
                    if (this.charAt(i + j) == open.charAt(j)) continue;
                    foundOpen = false;
                    break;
                }
                if (foundOpen && eraseStyle == EraseStyle.InlineMarkup && i != 0 && this.inlineMarkupDelimiters.length() > 0 && this.inlineMarkupDelimiters.indexOf(this.charAt(i - 1)) == -1) {
                    foundOpen = false;
                }
                if (!foundOpen) continue;
                enclosureStart = i;
                inEnclosure = true;
                firstEnclosurePosition = i;
                continue;
            }
            boolean foundClose = true;
            if (eraseStyle == EraseStyle.CloseMarkerContainsDelimiters) {
                foundClose = i == this.length() - 1 || close.indexOf(this.charAt(i)) != -1;
            } else {
                for (j = 0; j < close.length(); ++j) {
                    if (this.charAt(i + j) == close.charAt(j)) continue;
                    foundClose = false;
                    break;
                }
            }
            if (foundClose && eraseStyle == EraseStyle.InlineMarkup && i != this.length() - 1 && this.inlineMarkupDelimiters.length() > 0 && this.inlineMarkupDelimiters.indexOf(this.charAt(i + close.length())) == -1) {
                foundClose = false;
            }
            if (foundClose) {
                this.eraseWithStyle(open, close, eraseStyle, lastCommaPosition, enclosureStart, i);
                inEnclosure = false;
                lastCommaPosition = -1;
                continue;
            }
            if (this.charAt(i) != ',') continue;
            lastCommaPosition = i;
        }
        return firstEnclosurePosition;
    }

    private void eraseWithStyle(String open, String close, EraseStyle eraseStyle, int lastCommaPosition, int enclosureStart, int cloaseStart) {
        switch (eraseStyle) {
            case All: {
                this.erase(enclosureStart, cloaseStart - enclosureStart + close.length());
                break;
            }
            case Markers: 
            case InlineMarkup: {
                this.erase(enclosureStart, open.length());
                this.erase(cloaseStart, close.length());
                break;
            }
            case PreserveLabel: {
                if (lastCommaPosition != -1) {
                    this.erase(enclosureStart, lastCommaPosition + 1 - enclosureStart);
                    this.erase(cloaseStart, close.length());
                    break;
                }
                this.erase(enclosureStart, open.length());
                this.erase(cloaseStart, close.length());
                break;
            }
            case PreserveAfterLabel: {
                this.erase(enclosureStart, open.length());
                this.erase(lastCommaPosition, cloaseStart - lastCommaPosition);
                this.erase(cloaseStart, close.length());
                break;
            }
            case CloseMarkerContainsDelimiters: {
                this.erase(enclosureStart, cloaseStart == this.length() - 1 ? this.length() - enclosureStart : cloaseStart - enclosureStart);
                break;
            }
        }
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public String toString() {
        String result = "";
        for (int i = 0; i < this.characters.size(); ++i) {
            result = this.valid.get(i) != false ? result + this.characters.get(i) : result + "\u00b7" + this.characters.get(i);
        }
        return (this.erased ? "X" : " ") + (this.inBlock ? "[" : " ") + this.sectionLevel + "-" + this.listLevel + "-" + String.format("%03d", this.lineNo) + (this.listStart ? "*" : ":") + " " + result;
    }

    public static enum EraseStyle {
        All,
        None,
        Markers,
        InlineMarkup,
        PreserveLabel,
        PreserveAfterLabel,
        CloseMarkerContainsDelimiters;

    }
}

