/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser.common;

import cc.redpen.RedPenException;
import cc.redpen.model.Document;
import cc.redpen.parser.BaseDocumentParser;
import cc.redpen.parser.SentenceExtractor;
import cc.redpen.parser.common.Line;
import cc.redpen.parser.common.Model;
import cc.redpen.tokenizer.RedPenTokenizer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;

public abstract class LineParser
extends BaseDocumentParser {
    @Override
    public Document parse(InputStream io, Optional<String> fileName, SentenceExtractor sentenceExtractor, RedPenTokenizer tokenizer) throws RedPenException {
        Document.DocumentBuilder documentBuilder = Document.builder(tokenizer);
        fileName.ifPresent(documentBuilder::setFileName);
        Model model = new Model(sentenceExtractor);
        this.populateModel(model, io);
        documentBuilder.setPreprocessorRules(model.getPreprocessorRules());
        this.convertModel(model, documentBuilder);
        return documentBuilder.build();
    }

    protected void convertModel(Model model, Document.DocumentBuilder builder) {
        model.rewind();
        if (model.getCurrentLine() != null && model.getCurrentLine().getSectionLevel() == 0) {
            builder.addSection(0);
        }
        while (model.isMore()) {
            while (model.isMore() && model.getCurrentLine().isEmpty()) {
                model.getNextLine();
            }
            if (!model.isMore()) {
                return;
            }
            if (model.getCurrentLine().getSectionLevel() > 0) {
                builder.addSection(model.getCurrentLine().getSectionLevel(), model.convertToSentences(model.getCurrentLine()));
                model.getNextLine();
                continue;
            }
            if (model.getCurrentLine().isListStart()) {
                ArrayList<Line> listElementLines = new ArrayList<Line>();
                int listLevel = model.getCurrentLine().getListLevel();
                listElementLines.add(model.getCurrentLine());
                model.getNextLine();
                while (model.isMore() && !model.getCurrentLine().isListStart() && model.getCurrentLine().getListLevel() == listLevel) {
                    listElementLines.add(model.getCurrentLine());
                    model.getNextLine();
                }
                builder.addListElement(listLevel, model.convertToSentences(listElementLines));
                continue;
            }
            ArrayList<Line> paragraphLines = new ArrayList<Line>();
            while (model.isMore() && !model.getCurrentLine().isEmpty()) {
                paragraphLines.add(model.getCurrentLine());
                model.getNextLine();
            }
            builder.addParagraph();
            model.convertToSentences(paragraphLines).forEach(builder::addSentence);
        }
    }

    protected abstract void populateModel(Model var1, InputStream var2);

    public static class TargetLine {
        public Line line;
        public Line previousLine;
        public Line nextLine;
        public char firstChar;
        public char secondChar;

        public TargetLine(Line line, Line previousLine, Line nextLine) {
            this.line = line;
            this.previousLine = previousLine;
            this.nextLine = nextLine;
            this.firstChar = line.charAt(0);
            this.secondChar = line.charAt(1);
        }
    }
}

