/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser.common;

import cc.redpen.model.Sentence;
import cc.redpen.parser.LineOffset;
import cc.redpen.parser.PreprocessorRule;
import cc.redpen.parser.SentenceExtractor;
import cc.redpen.parser.common.Line;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Model {
    private static final Line EMPTY_LINE = new Line("", 0);
    private List<Line> lines = new ArrayList<Line>();
    private int lineIndex = 0;
    private SentenceExtractor sentenceExtractor;
    private Set<PreprocessorRule> preprocessorRules = new HashSet<PreprocessorRule>();

    public Model(SentenceExtractor sentenceExtractor) {
        this.sentenceExtractor = sentenceExtractor;
    }

    public Line getLine(int lineNumber) {
        int index = lineNumber - 1;
        if (index >= 0 && index < this.lines.size()) {
            return this.lines.get(index);
        }
        return EMPTY_LINE;
    }

    public void add(Line line) {
        this.lines.add(line);
    }

    public int lineCount() {
        return this.lines.size();
    }

    public void rewind() {
        this.lineIndex = 0;
    }

    public Line getNextLine() {
        if (this.lineIndex < this.lines.size()) {
            Line line = this.lines.get(this.lineIndex);
            ++this.lineIndex;
            return line;
        }
        return null;
    }

    public Line getCurrentLine() {
        if (this.lineIndex < this.lines.size()) {
            Line line = this.lines.get(this.lineIndex);
            return line;
        }
        return null;
    }

    public boolean isMore() {
        return this.lineIndex < this.lines.size();
    }

    public List<Sentence> convertToSentences(Line line) {
        ArrayList<Line> lines = new ArrayList<Line>();
        lines.add(line);
        return this.convertToSentences(lines);
    }

    public List<Sentence> convertToSentences(List<Line> lines) {
        ArrayList<Sentence> sentences = new ArrayList<Sentence>();
        String content = "";
        ArrayList<LineOffset> offsets = new ArrayList<LineOffset>();
        for (int ln = 0; ln < lines.size(); ++ln) {
            Line line = lines.get(ln);
            for (int i = 0; i < line.length(); ++i) {
                if (!line.isValid(i)) continue;
                content = content + line.rawCharAt(i);
                offsets.add(new LineOffset(line.getLineNo(), line.getOffset(i)));
                if (this.sentenceExtractor.getSentenceEndPosition("" + line.rawCharAt(i)) == -1) continue;
                sentences.add(new Sentence(content, offsets, Collections.EMPTY_LIST));
                content = "";
                offsets = new ArrayList();
            }
            if (lines.size() <= 1 || ln == lines.size() - 1) continue;
            for (char c : this.sentenceExtractor.getBrokenLineSeparator().toCharArray()) {
                content = content + c;
                offsets.add(new LineOffset(line.getLineNo(), line.getOffset(line.length())));
            }
        }
        if (!content.trim().isEmpty()) {
            sentences.add(new Sentence(content, offsets, Collections.EMPTY_LIST));
        }
        return sentences;
    }

    public Set<PreprocessorRule> getPreprocessorRules() {
        return this.preprocessorRules;
    }

    public void setPreprocessorRules(Set<PreprocessorRule> preprocessorRules) {
        this.preprocessorRules = preprocessorRules;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Line ostring : this.lines) {
            sb.append(ostring.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

