/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser.latex;

import cc.redpen.model.Document;
import cc.redpen.model.Paragraph;
import cc.redpen.model.Section;
import cc.redpen.model.Sentence;
import cc.redpen.parser.LineOffset;
import cc.redpen.parser.SentenceExtractor;
import cc.redpen.parser.latex.Position;
import cc.redpen.parser.latex.StreamParser;
import cc.redpen.parser.latex.Token;
import cc.redpen.parser.markdown.CandidateSentence;
import cc.redpen.parser.markdown.MergedCandidateSentence;
import cc.redpen.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaTeXProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LaTeXProcessor.class);

    public void parse(char[] stream, Document.DocumentBuilder builder, SentenceExtractor sentenceExtractor) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        new StreamParser(stream, t -> tokens.add(t)).parse();
        Processing.walkWith(Context.of(builder, sentenceExtractor), tokens);
    }

    static class Processing {
        Processing() {
        }

        public static void walkWith(Context c, List<Token> tokens) {
            for (Token t : tokens) {
                switch (t.t) {
                    case "PART": 
                    case "CHAPTER": 
                    case "SECTION": 
                    case "SUBSECTION": 
                    case "SUBSUBSECTION": {
                        Documents.appendSection(c, t);
                        break;
                    }
                    case "TEXTILE": {
                        if (t.isBlankLine()) {
                            Documents.appendParagraph(c);
                            break;
                        }
                        Documents.addAsCandidate(c, t);
                    }
                }
            }
            Documents.flushSentences(c);
        }
    }

    static class Documents {
        Documents() {
        }

        private static void flushSentences(Context c) {
            for (Sentence sentence : Documents.compileAsSentenceList(c)) {
                c.builder.addSentence(sentence);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static List<Sentence> compileAsSentenceList(Context c) {
            try {
                List<Sentence> list = Documents.sentencesIn(c, MergedCandidateSentence.merge(c.candidateSentences).get());
                return list;
            }
            catch (NoSuchElementException e) {
                ArrayList<Sentence> arrayList = new ArrayList<Sentence>();
                return arrayList;
            }
            finally {
                try {
                    c.candidateSentences.clear();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }

        private static List<Sentence> sentencesIn(Context c, MergedCandidateSentence mergedCandidateSentence) {
            ArrayList<Sentence> outputSentences = new ArrayList<Sentence>();
            ArrayList<Pair<Integer, Integer>> sentencePositions = new ArrayList<Pair<Integer, Integer>>();
            String line = mergedCandidateSentence.getContents();
            int lastPosition = c.sentenceExtractor.extract(line, sentencePositions);
            for (Pair pair : sentencePositions) {
                List<LineOffset> offsetMap = mergedCandidateSentence.getOffsetMap().subList((Integer)pair.first, (Integer)pair.second);
                outputSentences.add(new Sentence(line.substring((Integer)pair.first, (Integer)pair.second), offsetMap, mergedCandidateSentence.getRangedLinks((Integer)pair.first, (Integer)pair.second - 1)));
            }
            if (lastPosition < mergedCandidateSentence.getContents().length()) {
                List<LineOffset> offsetMap = mergedCandidateSentence.getOffsetMap().subList(lastPosition, mergedCandidateSentence.getContents().length());
                outputSentences.add(new Sentence(line.substring(lastPosition, mergedCandidateSentence.getContents().length()), offsetMap, mergedCandidateSentence.getRangedLinks(lastPosition, mergedCandidateSentence.getContents().length())));
            }
            return outputSentences;
        }

        private static boolean addChild(Section candidate, Section child) {
            try {
                Section parent = Documents.suitableParentFor(child, candidate);
                parent.appendSubSection(child);
                child.setParentSection(parent);
                return true;
            }
            catch (IllegalStateException ignore) {
                return false;
            }
        }

        private static Section suitableParentFor(Section target, Section from) throws IllegalStateException {
            Section s = from;
            while (true) {
                if (s == null) {
                    throw new IllegalStateException();
                }
                if (s.getLevel() < target.getLevel()) {
                    return s;
                }
                s = s.getParentSection();
            }
        }

        private static List<Sentence> asHeaderContents(List<Sentence> headerContents) {
            if (headerContents.size() > 0) {
                headerContents.get(0).setIsFirstSentence(true);
            }
            return headerContents;
        }

        private static int outlineLevelOf(Token t) {
            switch (t.t) {
                case "PART": {
                    return 1;
                }
                case "CHAPTER": {
                    return 2;
                }
                case "SECTION": {
                    return 3;
                }
                case "SUBSECTION": {
                    return 4;
                }
                case "SUBSUBSECTION": {
                    return 5;
                }
            }
            return 6;
        }

        public static void appendSection(Context c, Token t) {
            Documents.flushSentences(c);
            Documents.addAsCandidate(c, t, token -> token.asVerbatim());
            Section currentSection = c.builder.getLastSection();
            Section newSection = new Section(Documents.outlineLevelOf(t), Documents.asHeaderContents(Documents.compileAsSentenceList(c)));
            c.builder.appendSection(newSection);
            if (!Documents.addChild(Documents.trimmedSection(currentSection), newSection)) {
                LOG.warn("Failed to add parent for a Section: " + newSection.getHeaderContents().get(0));
            }
        }

        private static Section trimmedSection(Section s) {
            try {
                Paragraph p = s.getParagraph(s.getNumberOfParagraphs() - 1);
                if (p.getSentences().isEmpty()) {
                    s.getParagraphs().remove(p);
                }
                return s;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return s;
            }
        }

        private static List<CandidateSentence> candidatesOfSentence(Token t, String sep, Textizer textizer) {
            ArrayDeque<CandidateSentence> o = new ArrayDeque<CandidateSentence>();
            Position p = t.pos;
            for (String s : textizer.do_(t).split("\n")) {
                o.addLast(new CandidateSentence(p.row, s, null, p.col));
                p = new Position(p.row + 1, 0);
                o.addLast(new CandidateSentence(p.row, sep, null, p.col));
            }
            o.pollLast();
            return new ArrayList<CandidateSentence>(o);
        }

        private static void addAsCandidate(Context c, Token t, Textizer textizer) {
            c.candidateSentences.addAll(Documents.candidatesOfSentence(t, c.sentenceExtractor.getBrokenLineSeparator(), textizer));
        }

        public static void addAsCandidate(Context c, Token t) {
            c.candidateSentences.addAll(Documents.candidatesOfSentence(t, c.sentenceExtractor.getBrokenLineSeparator(), token -> token.asTextile()));
        }

        public static void appendParagraph(Context c) {
            Documents.flushSentences(c);
            c.builder.addParagraph();
        }

        private static interface Textizer {
            public String do_(Token var1);
        }
    }

    static class Context {
        public Document.DocumentBuilder builder;
        public SentenceExtractor sentenceExtractor;
        public List<CandidateSentence> candidateSentences = new ArrayList<CandidateSentence>();

        Context() {
        }

        public static Context of(Document.DocumentBuilder builder, SentenceExtractor sentenceExtractor) {
            Context o = new Context();
            o.builder = builder;
            o.sentenceExtractor = sentenceExtractor;
            return o;
        }
    }
}

