/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser.latex;

import cc.redpen.parser.latex.Flusher;
import cc.redpen.parser.latex.Position;
import cc.redpen.parser.latex.Token;
import java.util.ArrayList;
import java.util.List;

public class Lexer {
    private static final String SPECIALS = "[-=;:'\"<>,.?%!#^&()\\/{}[]$+| \r\n\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f]";
    private static final String WHITESPACE = " \r\n\t";
    private char[] mTarget;
    private String mMode = "TEXTILE";
    private List<Character> mRegister = new ArrayList<Character>();
    private Character mDelimiter = null;
    private Position mPos = new Position(1, 0);
    private Position mModeFrom = new Position(1, 0);

    private Lexer(char[] target) {
        this.mTarget = target;
    }

    public static Lexer on(char[] target) {
        return new Lexer(target);
    }

    public static Lexer on(String target) {
        return new Lexer(target.toCharArray());
    }

    public List<Token> parse() {
        ArrayList<Token> ret = new ArrayList<Token>();
        for (int i = 0; i < this.mTarget.length; ++i) {
            char c = this.mTarget[i];
            this.doParse(ret, c);
            if (c != '\n') {
                ++this.mPos.col;
                continue;
            }
            ++this.mPos.row;
            this.mPos.col = 0;
        }
        this.flush(ret);
        return ret;
    }

    private void doParse(List<Token> o, char c) {
        switch (this.mMode) {
            case "TEXTILE": {
                this.doParseTextile(o, c);
                break;
            }
            case "FORMULA": {
                this.doParseFormula(o, c);
                break;
            }
            case "COMMENT": 
            case "COMMENT_TRAILER": {
                this.doParseComment(o, c);
                break;
            }
            case "CONTROL": {
                this.doParseControl(o, c);
                break;
            }
            case "VERBATIM": {
                this.doParseVerbatim(o, c);
                break;
            }
            case "ESCAPING": {
                this.doParseEscaping(o, c);
            }
        }
    }

    private void doParseTextile(List<Token> o, char c) {
        switch (c) {
            case '%': {
                this.flush(o);
                this.mMode = "COMMENT";
                break;
            }
            case '\\': {
                this.flush(o);
                this.savePosition();
                this.mMode = "ESCAPING";
                break;
            }
            case '{': {
                this.flush(o);
                this.savePositionWithOffset(0, 1);
                this.synthesize(o, "GROUP1_BEGIN", c);
                break;
            }
            case '}': {
                this.flush(o);
                this.savePositionWithOffset(0, 1);
                this.synthesize(o, "GROUP1_END", c);
                break;
            }
            case '[': {
                this.flush(o);
                this.savePositionWithOffset(0, 1);
                this.synthesize(o, "GROUP2_BEGIN", c);
                break;
            }
            case ']': {
                this.flush(o);
                this.savePositionWithOffset(0, 1);
                this.synthesize(o, "GROUP2_END", c);
                break;
            }
            case '$': {
                this.mMode = "FORMULA";
                break;
            }
            default: {
                this.mRegister.add(Character.valueOf(c));
            }
        }
    }

    private void doParseFormula(List<Token> o, char c) {
        if (c == '$') {
            this.mMode = "TEXTILE";
        }
    }

    private void doParseComment(List<Token> o, char c) {
        switch (this.mMode) {
            case "COMMENT": {
                if (c == '\n') {
                    this.savePositionOfNextLine();
                    this.mMode = "TEXTILE";
                    break;
                }
                this.savePositionWithOffset(0, -1);
                this.mMode = "COMMENT_TRAILER";
                break;
            }
            case "COMMENT_TRAILER": {
                if (c != '\n') break;
                o.add(new Token("TEXTILE", "\n", this.mModeFrom));
                this.savePositionOfNextLine();
                this.mMode = "TEXTILE";
            }
        }
    }

    private void doParseControl(List<Token> o, char c) {
        if (SPECIALS.indexOf(c) < 0) {
            this.mRegister.add(Character.valueOf(c));
        } else {
            String word = Flusher.on(this.mRegister).flush();
            if ("verb".equals(word)) {
                this.savePosition();
                this.mMode = "VERBATIM";
                this.mDelimiter = Character.valueOf(c);
            } else if (word.length() > 0) {
                o.add(new Token(this.mMode, word, this.mModeFrom));
                this.savePosition();
                this.mMode = "TEXTILE";
                if (WHITESPACE.indexOf(c) < 0) {
                    this.doParse(o, c);
                }
            }
        }
    }

    private void doParseVerbatim(List<Token> o, char c) {
        if (c != this.mDelimiter.charValue()) {
            this.mRegister.add(Character.valueOf(c));
        } else {
            this.flush(o);
            this.savePosition();
            this.mMode = "TEXTILE";
        }
    }

    private void doParseEscaping(List<Token> o, char c) {
        if (SPECIALS.indexOf(c) < 0) {
            this.flush(o);
            this.savePosition();
            this.mMode = "CONTROL";
            this.doParse(o, c);
        } else {
            this.mMode = "TEXTILE";
            this.mRegister.add(Character.valueOf(c));
        }
    }

    private void synthesize(List<Token> l, String mode, char on) {
        l.add(new Token(mode, on, this.mPos));
    }

    private void flush(List<Token> l) {
        if (!this.mRegister.isEmpty()) {
            l.add(new Token(this.mMode, Flusher.on(this.mRegister).flush(), this.mModeFrom));
        }
    }

    private void savePosition() {
        this.savePositionWithOffset(0, 0);
    }

    private void savePositionWithOffset(int rowOffset, int colOffset) {
        this.mModeFrom = new Position(this.mPos);
        this.mModeFrom.row += rowOffset;
        this.mModeFrom.col += colOffset;
    }

    private void savePositionOfNextLine() {
        this.savePositionWithOffset(1, -this.mPos.col);
    }
}

