/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser.latex;

import cc.redpen.parser.latex.Lexer;
import cc.redpen.parser.latex.Position;
import cc.redpen.parser.latex.Token;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StreamParser {
    private char[] mTarget;
    private Listener mListener;

    public StreamParser(char[] s, Listener l) {
        this.mTarget = s;
        this.mListener = l;
    }

    public StreamParser(String s, Listener l) {
        this.mTarget = s.toCharArray();
        this.mListener = l;
    }

    public void parse() {
        List<Token> tokens = Lexer.on(this.mTarget).parse();
        for (Token t : Parsing.unescapeRegion(Parsing.styleTextileRegion(Parsing.assembleRegion(Parsing.pruneRegion(Parsing.normalizeTextileRegion(Parsing.maskTabularLikeRegion(Parsing.markVerbatimRegion(Parsing.collapse(tokens))))))))) {
            this.mListener.element(t);
        }
    }

    public static interface Listener {
        public void element(Token var1);
    }

    static class Parsing {
        public static final char ESCAPE_CHAR = '\ufffd';

        Parsing() {
        }

        public static List<Token> takeBlock(Deque<Token> q) {
            ArrayList<Token> o = new ArrayList<Token>();
            ArrayDeque<String> reg = new ArrayDeque<String>();
            try {
                do {
                    Token t = q.getFirst();
                    block5 : switch (t.t) {
                        case "GROUP1_BEGIN": 
                        case "GROUP2_BEGIN": {
                            reg.addLast(t.t);
                            break;
                        }
                        default: {
                            switch (t.t) {
                                case "GROUP1_END": {
                                    if (!"GROUP1_BEGIN".equals(reg.getLast())) break block5;
                                    reg.removeLast();
                                    break block5;
                                }
                                case "GROUP2_END": {
                                    if (!"GROUP2_BEGIN".equals(reg.getLast())) break block5;
                                    reg.removeLast();
                                }
                            }
                        }
                    }
                    if (reg.isEmpty() && o.isEmpty()) continue;
                    o.add(q.removeFirst());
                } while (!reg.isEmpty());
                return o;
            }
            catch (NoSuchElementException e) {
                return o;
            }
        }

        public static List<Token> takeTrailingBlocks(Deque<Token> q) {
            List<Token> block;
            ArrayList<Token> o = new ArrayList<Token>();
            while (!(block = Parsing.takeBlock(q)).isEmpty()) {
                o.addAll(block);
            }
            return o;
        }

        public static Token makeVerbatim(List<Token> tokens) {
            Token beginning = tokens.get(0);
            ArrayList<String> values = new ArrayList<String>();
            for (Token t : tokens) {
                values.add(t.asVerbatim());
                if (t.p.isEmpty()) continue;
                values.add(Parsing.makeVerbatim(t.p).v);
            }
            return new Token("VERBATIM", StringUtils.join(values, (String)""), beginning.pos);
        }

        public static List<Token> collapse(List<Token> tokens) {
            ArrayList<Token> o = new ArrayList<Token>();
            ArrayDeque<Token> q = new ArrayDeque<Token>(tokens);
            Pattern interests = Pattern.compile("(?:caption|part|(?:sub)*(chapter|section|paragraph)|item|title)\\*?");
            Pattern ignores = Pattern.compile(".?(?:space|fill)\\*?|phantom|documentclass|usepackage|author|date|label|ref|cite|biblio.*|includegraphics|footnote");
            try {
                while (true) {
                    Token t = (Token)q.removeFirst();
                    if ("CONTROL".equals(t.t)) {
                        if ("begin".equals(t.v) || "end".equals(t.v)) {
                            t.p = Parsing.takeTrailingBlocks(q);
                            switch (t.v) {
                                case "begin": {
                                    t.t = "ENVIRON_BEGIN";
                                    break;
                                }
                                case "end": {
                                    t.t = "ENVIRON_END";
                                }
                            }
                            o.add(t);
                            continue;
                        }
                        if (interests.matcher(t.v).matches()) {
                            t.p = Parsing.takeBlock(q);
                            t.t = t.t + "*";
                            o.add(t);
                            continue;
                        }
                        if (!ignores.matcher(t.v).matches()) continue;
                        t.p = Parsing.takeTrailingBlocks(q);
                        o.add(t);
                        continue;
                    }
                    o.add(t);
                }
            }
            catch (NoSuchElementException e) {
                return o;
            }
        }

        public static List<String> valuesOf(Iterable<Token> tokens) {
            ArrayList<String> o = new ArrayList<String>();
            for (Token t : tokens) {
                o.add(t.v);
            }
            return o;
        }

        public static List<String> textileValuesOf(Iterable<Token> tokens) {
            ArrayList<String> o = new ArrayList<String>();
            for (Token t : tokens) {
                o.add(t.asTextile());
            }
            return o;
        }

        public static List<Token> markVerbatimRegion(List<Token> tokens) {
            ArrayList<Token> o = new ArrayList<Token>();
            ArrayDeque<Token> q = new ArrayDeque<Token>(tokens);
            try {
                while (true) {
                    Token t = (Token)q.removeFirst();
                    if (!"ENVIRON_BEGIN".equals(t.t) || !Parsing.textileValuesOf(t.p).contains("verbatim")) {
                        o.add(t);
                        continue;
                    }
                    ArrayList<Token> verbatim = new ArrayList<Token>();
                    while (true) {
                        Token vt = (Token)q.removeFirst();
                        if ("ENVIRON_END".equals(vt.t) && Parsing.textileValuesOf(vt.p).contains("verbatim")) break;
                        verbatim.add(vt);
                    }
                    o.add(Parsing.makeVerbatim(verbatim));
                }
            }
            catch (NoSuchElementException e) {
                return o;
            }
        }

        public static List<Token> maskTabularLikeRegion(List<Token> tokens) {
            ArrayList<Token> o = new ArrayList<Token>();
            ArrayDeque<Token> q = new ArrayDeque<Token>(tokens);
            try {
                while (true) {
                    Token tt;
                    Token t = (Token)q.removeFirst();
                    if (!"ENVIRON_BEGIN".equals(t.t) || !Parsing.textileValuesOf(t.p).contains("tabular")) {
                        o.add(t);
                        continue;
                    }
                    do {
                        tt = (Token)q.removeFirst();
                    } while (!"ENVIRON_END".equals(tt.t) || !Parsing.textileValuesOf(tt.p).contains("tabular"));
                }
            }
            catch (NoSuchElementException e) {
                return o;
            }
        }

        public static List<Token> normalizeTextileRegion(List<Token> tokens) {
            ArrayList<Token> o = new ArrayList<Token>();
            ArrayDeque<Token> q = new ArrayDeque<Token>(tokens);
            try {
                while (true) {
                    Token t = (Token)q.removeFirst();
                    if (!"TEXTILE".equals(t.t)) {
                        o.add(t);
                        continue;
                    }
                    t.v = Pattern.compile("``|\u2019\u2019|''").matcher(t.v).replaceAll("\"");
                    t.v = Pattern.compile("`|\u2019").matcher(t.v).replaceAll("'");
                    o.add(t);
                }
            }
            catch (NoSuchElementException e) {
                return o;
            }
        }

        public static List<Token> pruneRegion(List<Token> tokens) {
            ArrayList<Token> o = new ArrayList<Token>();
            ArrayDeque<Token> q = new ArrayDeque<Token>(tokens);
            try {
                while (true) {
                    Token t = (Token)q.removeFirst();
                    if ("TEXTILE".equals(t.t)) {
                        o.add(t);
                        continue;
                    }
                    if (!"CONTROL*".equals(t.t)) continue;
                    o.add(new Token(t.v.toUpperCase(), StringUtils.join(Parsing.textileValuesOf(Parsing.pruneRegion(t.p)), (String)""), t.pos));
                }
            }
            catch (NoSuchElementException e) {
                return o;
            }
        }

        public static List<Token> assembleRegion(List<Token> tokens) {
            ArrayList<Token> o = new ArrayList<Token>();
            ArrayDeque<Token> q = new ArrayDeque<Token>(tokens);
            ArrayList<Token> reg = new ArrayList<Token>();
            try {
                while (true) {
                    Token t = (Token)q.removeFirst();
                    if ("TEXTILE".equals(t.t)) {
                        reg.add(t);
                        continue;
                    }
                    if (!reg.isEmpty()) {
                        Token first = (Token)reg.get(0);
                        o.add(new Token(first.t, StringUtils.join(Parsing.textileValuesOf(reg), (String)""), first.pos));
                        reg.clear();
                    }
                    o.add(t);
                }
            }
            catch (NoSuchElementException e) {
                if (!reg.isEmpty()) {
                    Token first = (Token)reg.get(0);
                    o.add(new Token(first.t, StringUtils.join(Parsing.textileValuesOf(reg), (String)""), first.pos));
                    reg.clear();
                }
                return o;
            }
        }

        public static List<Token> styleTextileRegion(List<Token> tokens) {
            ArrayList<Token> o = new ArrayList<Token>();
            ArrayDeque<Token> q = new ArrayDeque<Token>(tokens);
            Pattern EMPTY = Pattern.compile(String.format("^[ \\t\\r\\n%c]*$", Character.valueOf('\ufffd')));
            Pattern LINEBREAK = Pattern.compile("(\\r?\\n){2,}");
            try {
                block4: while (true) {
                    Token t = (Token)q.removeFirst();
                    if ("TEXTILE".equals(t.t)) {
                        if (EMPTY.matcher(t.v).matches()) continue;
                        String stripped = Parsing.stripTextBlock(t.v);
                        String[] stringArray = LINEBREAK.split(stripped);
                        int n = stringArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) continue block4;
                            String s = stringArray[n2];
                            Position p = new Position(Parsing._guessRow(t, s), Parsing._guessCol(t, s));
                            o.add(new Token(t.t, Parsing.maskCharactersInTextBlock(s), p));
                            o.add(new Token(t.t, "", p));
                            ++n2;
                        }
                    }
                    o.add(t);
                }
            }
            catch (NoSuchElementException e) {
                try {
                    Token last = (Token)o.get(o.size() - 1);
                    if (last.isBlankLine()) {
                        o.remove(last);
                    }
                    return o;
                }
                catch (ArrayIndexOutOfBoundsException ignore) {
                    return o;
                }
            }
        }

        public static String stripTextBlock(String b) {
            return Pattern.compile(String.format("^[ \\t\\r\\n%c]+", Character.valueOf('\ufffd'))).matcher(b).replaceAll("");
        }

        public static String compactTextBlock(String b) {
            return Pattern.compile(String.format("[ \\t\\r\\n%c]{2,}", Character.valueOf('\ufffd'))).matcher(b).replaceAll(" ");
        }

        public static String maskCharactersInTextBlock(String b) {
            return b.replace('~', ' ');
        }

        public static List<Token> unescapeRegion(List<Token> tokens) {
            ArrayList<Token> o = new ArrayList<Token>();
            for (Token t : tokens) {
                t.v = t.v.replace('\ufffd', ' ');
                o.add(t);
            }
            return o;
        }

        public static int countMatches(Pattern p, String s) {
            int ret = 0;
            Matcher m = p.matcher(s);
            while (m.find()) {
                ++ret;
            }
            return ret;
        }

        public static int _guessRow(Token t, String needle) {
            int lead = t.v.indexOf(needle);
            if (lead >= 0) {
                return t.pos.row + Parsing.countMatches(Pattern.compile("\\r?\\n"), t.v.substring(0, lead));
            }
            return t.pos.row;
        }

        public static int _guessCol(Token t, String needle) {
            int lead = t.v.indexOf(needle);
            if (lead >= 0) {
                int lastLinebreak = t.v.substring(0, lead).lastIndexOf("\n");
                if (lastLinebreak >= 0) {
                    return 0 + (lead - (lastLinebreak + 1));
                }
                return t.pos.col + lead;
            }
            return t.pos.col;
        }
    }
}

