/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser.latex;

import cc.redpen.parser.latex.Position;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Token {
    public static final String BLANK_LINE = "";
    public String t;
    public String v;
    public List<Token> p = new ArrayList<Token>();
    public Position pos;

    public Token(String type, String value, Position pos) {
        this.t = type;
        this.v = value;
        this.pos = new Position(pos);
    }

    public Token(String type, char value, Position pos) {
        this.t = type;
        this.v = String.valueOf(value);
        this.pos = new Position(pos);
    }

    public boolean equals(Token other) {
        return this.t == other.t && this.v == other.v && this.p.equals(other.p);
    }

    public String toString() {
        return String.format("%s(%s) \"%s\" %s", this.t, this.pos, this.v, this.p);
    }

    public String asTextile() {
        if ("TEXTILE".equals(this.t) || this.t.endsWith("*")) {
            return this.v;
        }
        return BLANK_LINE;
    }

    public String asVerbatim() {
        return this.v;
    }

    public boolean isEmptyAsTextile() {
        return Pattern.compile("^[ \\r\\n\\t]*$").matcher(this.asTextile()).matches();
    }

    public boolean isBlankLine() {
        return "TEXTILE".equals(this.t) && BLANK_LINE.equals(this.v);
    }
}

