/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser.markdown;

import cc.redpen.parser.LineOffset;
import java.util.ArrayList;
import java.util.List;

public final class CandidateSentence {
    private int lineNum;
    private String content;
    private String link;
    private int startPositionOffset;
    private List<LineOffset> offsetMap;

    public CandidateSentence(int lineNum, String content, String link) {
        this(lineNum, content, link, 0);
    }

    public CandidateSentence(int lineNum, String content, String link, int positionOffset) {
        this.lineNum = lineNum;
        this.content = content;
        this.link = link;
        this.startPositionOffset = positionOffset;
        this.offsetMap = new ArrayList<LineOffset>();
        for (int i = 0; i < content.length(); ++i) {
            this.offsetMap.add(new LineOffset(lineNum, positionOffset + i));
        }
    }

    public List<LineOffset> getOffsetMap() {
        return this.offsetMap;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public int getStartPositionOffset() {
        return this.startPositionOffset;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String text) {
        this.content = text;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String url) {
        this.link = url;
    }

    public String toString() {
        return "CandidateSentence{lineNum=" + this.lineNum + ", content='" + this.content + '\'' + ", link='" + this.link + '\'' + ", startPositionOffset=" + this.startPositionOffset + ", offsetMap=" + this.offsetMap + '}';
    }
}

