/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser.markdown;

import cc.redpen.parser.LineOffset;
import cc.redpen.parser.markdown.CandidateSentence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedCandidateSentence {
    private static final Logger LOG = LoggerFactory.getLogger(MergedCandidateSentence.class);
    private int lineNum;
    private String contents;
    private Map<LineOffset, String> links;
    private List<LineOffset> offsetMap;

    public MergedCandidateSentence(int lineNum, String contents, Map<LineOffset, String> links, List<LineOffset> offsetMap) {
        this.lineNum = lineNum;
        this.contents = contents;
        this.links = links;
        this.offsetMap = offsetMap;
    }

    public static Optional<MergedCandidateSentence> merge(List<CandidateSentence> candidateSentences) {
        if (candidateSentences.size() == 0) {
            return Optional.empty();
        }
        int lineNum = candidateSentences.get(0).getLineNum();
        StringBuilder contents = new StringBuilder();
        HashMap<LineOffset, String> links = new HashMap<LineOffset, String>();
        ArrayList<LineOffset> offsetMap = new ArrayList<LineOffset>();
        for (CandidateSentence sentence : candidateSentences) {
            contents.append(sentence.getContent());
            offsetMap.addAll(sentence.getOffsetMap());
            if (sentence.getLink() == null || sentence.getOffsetMap().size() <= 0) continue;
            links.put(sentence.getOffsetMap().get(0), sentence.getLink());
        }
        if (offsetMap.size() != contents.length()) {
            LOG.warn("Size of offset map (\"{}\") is not the same as sentence length \"{}\":  ", new Object[]{offsetMap.size(), contents.length(), contents});
        }
        return Optional.of(new MergedCandidateSentence(lineNum, contents.toString(), links, offsetMap));
    }

    public List<String> getRangedLinks(int startPosition, int endPosition) {
        if (startPosition >= this.offsetMap.size() || endPosition >= this.offsetMap.size()) {
            return new ArrayList<String>();
        }
        ArrayList<String> output = new ArrayList<String>();
        for (LineOffset linkPosition : this.links.keySet()) {
            if (linkPosition.compareTo(this.offsetMap.get(startPosition)) < 0 || linkPosition.compareTo(this.offsetMap.get(endPosition)) > 0) continue;
            output.add(this.getLinks().get(linkPosition));
        }
        return output;
    }

    public String getContents() {
        return this.contents;
    }

    public Map<LineOffset, String> getLinks() {
        return this.links;
    }

    public List<LineOffset> getOffsetMap() {
        return this.offsetMap;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public String toString() {
        return "MergedCandidateSentence{lineNum=" + this.lineNum + ", contents='" + this.contents + '\'' + ", links=" + this.links + ", offsetMap=" + this.offsetMap + '}';
    }
}

