/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser.markdown;

import cc.redpen.RedPenException;
import cc.redpen.model.Document;
import cc.redpen.model.Section;
import cc.redpen.model.Sentence;
import cc.redpen.parser.LineOffset;
import cc.redpen.parser.ParserUtils;
import cc.redpen.parser.SentenceExtractor;
import cc.redpen.parser.markdown.CandidateSentence;
import cc.redpen.parser.markdown.MergedCandidateSentence;
import cc.redpen.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.pegdown.Printer;
import org.pegdown.ast.AbbreviationNode;
import org.pegdown.ast.AnchorLinkNode;
import org.pegdown.ast.AutoLinkNode;
import org.pegdown.ast.BlockQuoteNode;
import org.pegdown.ast.BulletListNode;
import org.pegdown.ast.CodeNode;
import org.pegdown.ast.DefinitionListNode;
import org.pegdown.ast.DefinitionNode;
import org.pegdown.ast.DefinitionTermNode;
import org.pegdown.ast.ExpImageNode;
import org.pegdown.ast.ExpLinkNode;
import org.pegdown.ast.HeaderNode;
import org.pegdown.ast.HtmlBlockNode;
import org.pegdown.ast.InlineHtmlNode;
import org.pegdown.ast.ListItemNode;
import org.pegdown.ast.MailLinkNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.OrderedListNode;
import org.pegdown.ast.ParaNode;
import org.pegdown.ast.QuotedNode;
import org.pegdown.ast.RefImageNode;
import org.pegdown.ast.RefLinkNode;
import org.pegdown.ast.ReferenceNode;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.SimpleNode;
import org.pegdown.ast.SpecialTextNode;
import org.pegdown.ast.StrikeNode;
import org.pegdown.ast.StrongEmphSuperNode;
import org.pegdown.ast.SuperNode;
import org.pegdown.ast.TableBodyNode;
import org.pegdown.ast.TableCaptionNode;
import org.pegdown.ast.TableCellNode;
import org.pegdown.ast.TableColumnNode;
import org.pegdown.ast.TableHeaderNode;
import org.pegdown.ast.TableNode;
import org.pegdown.ast.TableRowNode;
import org.pegdown.ast.TextNode;
import org.pegdown.ast.VerbatimNode;
import org.pegdown.ast.Visitor;
import org.pegdown.ast.WikiLinkNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToFileContentSerializer
implements Visitor {
    private static final Logger LOG = LoggerFactory.getLogger(ToFileContentSerializer.class);
    private final Map<String, ReferenceNode> references = new HashMap<String, ReferenceNode>();
    private Document.DocumentBuilder builder = null;
    private SentenceExtractor sentenceExtractor;
    private int itemDepth = 0;
    private List<Integer> lineList = null;
    private List<CandidateSentence> candidateSentences = new ArrayList<CandidateSentence>();
    private Printer printer = new Printer();

    public ToFileContentSerializer(Document.DocumentBuilder docBuilder, List<Integer> listOfLineNumber, SentenceExtractor extractor) {
        this.builder = docBuilder;
        this.lineList = listOfLineNumber;
        this.sentenceExtractor = extractor;
    }

    protected void visitChildren(SuperNode node) {
        for (Node child : node.getChildren()) {
            child.accept((Visitor)this);
        }
    }

    public Document toFileContent(RootNode astRoot) throws RedPenException {
        try {
            Preconditions.checkArgNotNull((Object)astRoot, (String)"astRoot");
            astRoot.accept((Visitor)this);
        }
        catch (NullPointerException e) {
            LOG.error("Fail to traverse RootNode.");
            throw new RedPenException("Fail to traverse RootNode.", e);
        }
        return this.builder.build();
    }

    private void fixSentence() {
        List<Sentence> sentences = this.createSentenceList();
        for (Sentence sentence : sentences) {
            this.builder.addSentence(sentence);
        }
    }

    private void addCandidateSentence(int lineNum, String text, int positionOffset) {
        this.addCandidateSentence(lineNum, text, positionOffset, null);
    }

    private void addCandidateSentence(int lineNum, String text, int positionOffset, String link) {
        this.candidateSentences.add(new CandidateSentence(lineNum, text, link, positionOffset));
    }

    private int getLineNumberFromStartIndex(int startIndex) {
        int end;
        int lineNum = 1;
        Iterator<Integer> iterator = this.lineList.iterator();
        while (iterator.hasNext() && startIndex >= (end = iterator.next().intValue())) {
            ++lineNum;
        }
        return lineNum;
    }

    private int getLineStartIndex(int lineNumber) {
        if (lineNumber == 1) {
            return 0;
        }
        return this.lineList.get(lineNumber - 2);
    }

    private String printChildrenToString(SuperNode node) {
        Printer priorPrinter = this.printer;
        this.printer = new Printer();
        this.visitChildren(node);
        String result = this.printer.getString();
        this.printer = priorPrinter;
        return result;
    }

    private List<Sentence> createSentenceList() {
        ArrayList<Sentence> outputSentences = new ArrayList<Sentence>();
        Optional<MergedCandidateSentence> mergedCandidateSentence = MergedCandidateSentence.merge(this.candidateSentences);
        mergedCandidateSentence.ifPresent(m -> this.extractSentences((MergedCandidateSentence)m, (List<Sentence>)outputSentences));
        this.candidateSentences.clear();
        return outputSentences;
    }

    private List<Sentence> extractSentences(MergedCandidateSentence mergedCandidateSentence, List<Sentence> outputSentences) {
        ArrayList<Pair<Integer, Integer>> sentencePositions = new ArrayList<Pair<Integer, Integer>>();
        String line = mergedCandidateSentence.getContents();
        int lastPosition = this.sentenceExtractor.extract(line, sentencePositions);
        for (Pair pair : sentencePositions) {
            List<LineOffset> offsetMap = mergedCandidateSentence.getOffsetMap().subList((Integer)pair.first, (Integer)pair.second);
            outputSentences.add(new Sentence(line.substring((Integer)pair.first, (Integer)pair.second), offsetMap, mergedCandidateSentence.getRangedLinks((Integer)pair.first, (Integer)pair.second - 1)));
        }
        if (lastPosition < mergedCandidateSentence.getContents().length()) {
            List<LineOffset> offsetMap = mergedCandidateSentence.getOffsetMap().subList(lastPosition, mergedCandidateSentence.getContents().length());
            outputSentences.add(new Sentence(line.substring(lastPosition, mergedCandidateSentence.getContents().length()), offsetMap, mergedCandidateSentence.getRangedLinks(lastPosition, mergedCandidateSentence.getContents().length())));
        }
        return outputSentences;
    }

    private void appendSection(HeaderNode headerNode) {
        this.fixSentence();
        this.visitChildren((SuperNode)headerNode);
        List<Sentence> headerContents = this.createSentenceList();
        if (headerContents.size() > 0) {
            headerContents.get(0).setIsFirstSentence(true);
        }
        Section currentSection = this.builder.getLastSection();
        this.builder.appendSection(new Section(headerNode.getLevel(), headerContents));
        if (!ParserUtils.addChild(currentSection, this.builder.getLastSection())) {
            LOG.warn("Failed to add parent for a Section");
            if (this.builder.getLastSection().getHeaderContents() != null && this.builder.getLastSection().getHeaderContents().size() > 0) {
                this.builder.getLastSection().getHeaderContents().get(0);
            }
        }
    }

    public void visit(AbbreviationNode abbreviationNode) {
    }

    public void visit(AnchorLinkNode anchorLinkNode) {
    }

    public void visit(AutoLinkNode autoLinkNode) {
        int lineNumber = this.getLineNumberFromStartIndex(autoLinkNode.getStartIndex());
        this.addCandidateSentence(lineNumber, autoLinkNode.getText(), autoLinkNode.getStartIndex() - this.getLineStartIndex(lineNumber), autoLinkNode.getText());
    }

    public void visit(BlockQuoteNode blockQuoteNode) {
    }

    public void visit(CodeNode codeNode) {
        int lineNumber = this.getLineNumberFromStartIndex(codeNode.getStartIndex());
        this.addCandidateSentence(this.getLineNumberFromStartIndex(codeNode.getStartIndex()), codeNode.getText(), codeNode.getStartIndex() - this.getLineStartIndex(lineNumber));
    }

    public void visit(ExpImageNode expImageNode) {
    }

    public void visit(ExpLinkNode expLinkNode) {
        String linkName = this.printChildrenToString((SuperNode)expLinkNode);
        if (this.candidateSentences.size() == 0) {
            return;
        }
        CandidateSentence lastCandidateSentence = this.candidateSentences.get(this.candidateSentences.size() - 1);
        lastCandidateSentence.setLink(expLinkNode.url);
    }

    public void visit(HeaderNode headerNode) {
        this.appendSection(headerNode);
    }

    public void visit(BulletListNode bulletListNode) {
        if (this.itemDepth == 0) {
            this.fixSentence();
            this.builder.addListBlock();
        } else {
            List<Sentence> sentences = this.createSentenceList();
            this.builder.addListElement(this.itemDepth, sentences);
        }
        ++this.itemDepth;
        this.visitChildren((SuperNode)bulletListNode);
        --this.itemDepth;
    }

    public void visit(OrderedListNode orderedListNode) {
        if (this.itemDepth == 0) {
            this.fixSentence();
            this.builder.addListBlock();
        } else {
            List<Sentence> sentences = this.createSentenceList();
            this.builder.addListElement(this.itemDepth, sentences);
        }
        ++this.itemDepth;
        this.visitChildren((SuperNode)orderedListNode);
        --this.itemDepth;
    }

    public void visit(ListItemNode listItemNode) {
        this.visitChildren((SuperNode)listItemNode);
        List<Sentence> sentences = this.createSentenceList();
        if (sentences != null && sentences.size() > 0) {
            this.builder.addListElement(this.itemDepth, sentences);
        }
    }

    public void visit(ParaNode paraNode) {
        this.builder.addParagraph();
        this.visitChildren((SuperNode)paraNode);
        this.fixSentence();
    }

    public void visit(RootNode rootNode) {
        for (ReferenceNode referenceNode : rootNode.getReferences()) {
        }
        for (ReferenceNode referenceNode : rootNode.getAbbreviations()) {
        }
        this.visitChildren((SuperNode)rootNode);
    }

    public void visit(SimpleNode simpleNode) {
        int lineNumber = this.getLineNumberFromStartIndex(simpleNode.getStartIndex());
        int offsetInLine = simpleNode.getStartIndex() - this.getLineStartIndex(lineNumber);
        switch (simpleNode.getType()) {
            case Linebreak: {
                if (simpleNode.getEndIndex() - simpleNode.getStartIndex() > 1) {
                    this.addCandidateSentence(lineNumber, StringUtils.repeat((char)' ', (int)(simpleNode.getEndIndex() - simpleNode.getStartIndex() - 1)), offsetInLine);
                }
                this.addCandidateSentence(this.getLineNumberFromStartIndex(simpleNode.getEndIndex()), this.sentenceExtractor.getBrokenLineSeparator(), 0);
                break;
            }
            case Nbsp: {
                break;
            }
            case HRule: {
                break;
            }
            case Apostrophe: {
                this.addCandidateSentence(lineNumber, "'", offsetInLine);
                break;
            }
            case Ellipsis: {
                this.addCandidateSentence(lineNumber, "...", offsetInLine);
                break;
            }
            case Emdash: {
                this.addCandidateSentence(lineNumber, "\u2013", offsetInLine);
                break;
            }
            case Endash: {
                this.addCandidateSentence(lineNumber, "\u2014", offsetInLine);
                break;
            }
            default: {
                LOG.warn("Illegal SimpleNode:[" + simpleNode.toString() + "]");
            }
        }
    }

    public void visit(SpecialTextNode specialTextNode) {
        int lineNumber = this.getLineNumberFromStartIndex(specialTextNode.getStartIndex());
        this.addCandidateSentence(this.getLineNumberFromStartIndex(specialTextNode.getStartIndex()), specialTextNode.getText(), specialTextNode.getStartIndex() - this.getLineStartIndex(lineNumber));
    }

    public void visit(StrikeNode strikeNode) {
        this.visitChildren((SuperNode)strikeNode);
    }

    public void visit(StrongEmphSuperNode strongEmphSuperNode) {
        this.visitChildren((SuperNode)strongEmphSuperNode);
    }

    public void visit(TextNode textNode) {
        int lineNumber = this.getLineNumberFromStartIndex(textNode.getStartIndex());
        this.addCandidateSentence(this.getLineNumberFromStartIndex(textNode.getStartIndex()), textNode.getText(), textNode.getStartIndex() - this.getLineStartIndex(lineNumber));
        this.printer.print(textNode.getText());
    }

    public void visit(VerbatimNode verbatimNode) {
    }

    public void visit(QuotedNode quotedNode) {
    }

    public void visit(ReferenceNode referenceNode) {
    }

    public void visit(RefImageNode refImageNode) {
    }

    public void visit(RefLinkNode refLinkNode) {
        String linkName = this.printChildrenToString((SuperNode)refLinkNode);
        String url = this.getRefLinkUrl(refLinkNode.referenceKey, linkName);
        CandidateSentence lastCandidateSentence = this.candidateSentences.get(this.candidateSentences.size() - 1);
        if (StringUtils.isNotEmpty((String)url)) {
            lastCandidateSentence.setLink(url);
        } else {
            lastCandidateSentence.setContent(lastCandidateSentence.getContent());
        }
    }

    private String getRefLinkUrl(SuperNode referenceKey, String linkName) {
        ReferenceNode refNode = this.references.get(linkName);
        StringBuilder sb = new StringBuilder();
        if (refNode != null) {
            sb.append(refNode.getUrl());
        }
        return sb.toString();
    }

    public void visit(HtmlBlockNode htmlBlockNode) {
    }

    public void visit(InlineHtmlNode inlineHtmlNode) {
    }

    public void visit(MailLinkNode mailLinkNode) {
    }

    public void visit(WikiLinkNode wikiLinkNode) {
    }

    public void visit(SuperNode superNode) {
        this.visitChildren(superNode);
    }

    public void visit(Node node) {
    }

    public void visit(DefinitionListNode definitionListNode) {
    }

    public void visit(DefinitionNode definitionNode) {
    }

    public void visit(DefinitionTermNode definitionTermNode) {
    }

    public void visit(TableBodyNode tableBodyNode) {
    }

    public void visit(TableCaptionNode tableCaptionNode) {
    }

    public void visit(TableCellNode tableCellNode) {
    }

    public void visit(TableColumnNode tableColumnNode) {
    }

    public void visit(TableHeaderNode tableHeaderNode) {
    }

    public void visit(TableNode tableNode) {
        this.visitChildren((SuperNode)tableNode);
    }

    public void visit(TableRowNode tableRowNode) {
    }
}

