/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser.rest;

import cc.redpen.parser.PreprocessingReader;
import cc.redpen.parser.common.Line;
import cc.redpen.parser.common.LineParser;
import cc.redpen.parser.common.Model;
import cc.redpen.parser.rest.MultiLineProcessUtils;
import cc.redpen.parser.rest.ReSTLine;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReSTParser
extends LineParser {
    private static final Logger LOG = LoggerFactory.getLogger(ReSTParser.class);
    static Pattern DIGIT_PATTERN = Pattern.compile("^\\s*[0-9#]+\\.");
    static Pattern NORMAL_TABLE_PATTERN = Pattern.compile("^[+][-+]+[+]$");
    static Pattern CSV_TABLE_PATTERN = Pattern.compile("^=+[= ]+=$");
    static Pattern DIRECTIVE_PATTERN = Pattern.compile("^[.][.] [a-z]+::");
    static Pattern INLINE_COMMENT_PATTERN = Pattern.compile("^[.][.] [^\\[][^:]+$");
    static Pattern FOOTNOTE_PATTERN = Pattern.compile("^[.][.] \\[.+\\].+");

    @Override
    protected void populateModel(Model model, InputStream io) {
        State state = new State();
        PreprocessingReader reader = this.createReader(io);
        int lineno = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                model.add(new ReSTLine(line, ++lineno));
            }
            reader.close();
            model.setPreprocessorRules(reader.getPreprocessorRules());
            model.rewind();
            while (model.isMore()) {
                this.processLine(model.getCurrentLine(), model, state);
                model.getNextLine();
            }
        }
        catch (Exception e) {
            LOG.error("Exception when parsing reST file", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("reST parser model (X=erased line,[=block,section-listlevel-lineno,*=list item):\n" + model.toString());
        }
    }

    private void processLine(Line line, Model model, State state) {
        if (line.isErased()) {
            return;
        }
        LineParser.TargetLine target = new LineParser.TargetLine(line, model.getLine(line.getLineNo() - 1), model.getLine(line.getLineNo() + 1));
        int level = this.extractSectionLevel(target);
        if (level > 0) {
            line.setSectionLevel(level);
            this.reset(state);
        }
        this.eraseInlineMarkup(line);
        if (!state.inBlock && this.isListElement(target, state)) {
            state.inList = true;
        }
        if (!state.inBlock && this.isTable(target, state)) {
            state.inTable = true;
        }
        if (this.isDirective(target, state)) {
            state.inBlock = true;
        }
        if (this.isLiteral(target, state)) {
            state.inBlock = true;
        }
        if (this.isComment(target, state)) {
            state.inBlock = true;
        }
        this.handlelineBlock(line);
        this.handleFootnote(line);
        if (this.isEndBlock(target)) {
            this.reset(state);
        }
        if (state.inBlock) {
            line.erase();
        }
    }

    private void handleFootnote(Line line) {
        Matcher m = FOOTNOTE_PATTERN.matcher(line.getText());
        if (m.find()) {
            line.erase(0, line.getText().indexOf(93) + 2);
        }
    }

    private void handlelineBlock(Line line) {
        if (line.charAt(0) == '|' && line.charAt(1) == ' ') {
            line.erase();
        } else if (line.startsWith(">>>")) {
            line.erase();
        }
    }

    private boolean isEndBlock(LineParser.TargetLine target) {
        return target.line.length() == 0 && target.nextLine.charAt(0) != ' ' && target.nextLine.charAt(1) != ' ' && target.nextLine.charAt(0) != '\t';
    }

    private boolean isLiteral(LineParser.TargetLine target, State state) {
        Line line = target.line;
        return line.length() == 2 && line.charAt(0) == ':' && line.charAt(1) == ':' && target.nextLine.length() == 0;
    }

    private boolean isComment(LineParser.TargetLine target, State state) {
        Line line = target.line;
        Matcher m = INLINE_COMMENT_PATTERN.matcher(target.line.getText());
        if (m.find()) {
            target.line.erase();
            return true;
        }
        return line.length() == 2 && line.charAt(0) == '.' && line.charAt(1) == '.';
    }

    private boolean isDirective(LineParser.TargetLine target, State state) {
        Matcher m = DIRECTIVE_PATTERN.matcher(target.line.getText());
        if (m.find()) {
            target.line.erase();
            return true;
        }
        return false;
    }

    private void reset(State state) {
        state.inList = false;
        state.inBlock = false;
        state.inTable = false;
        state.eraseDirective = false;
        state.type = "";
    }

    private boolean isTable(LineParser.TargetLine target, State state) {
        Line line = target.line;
        if (state.inTable) {
            line.erase();
            return true;
        }
        if (this.isNormalTable(target, state)) {
            return true;
        }
        return this.isCSVTable(target, state);
    }

    private boolean isNormalTable(LineParser.TargetLine target, State state) {
        Matcher m = NORMAL_TABLE_PATTERN.matcher(target.line.getText());
        if (m.find()) {
            target.line.erase();
            return true;
        }
        return false;
    }

    private boolean isCSVTable(LineParser.TargetLine target, State state) {
        Matcher m = CSV_TABLE_PATTERN.matcher(target.line.getText());
        if (m.find()) {
            target.line.erase();
            return true;
        }
        return false;
    }

    private boolean isListElement(LineParser.TargetLine line, State state) {
        if (this.isNormalList(line, state)) {
            return true;
        }
        if (this.isDigitList(line, state)) {
            return true;
        }
        return this.isDefinitionList(line, state);
    }

    private boolean isNormalList(LineParser.TargetLine target, State state) {
        Line line = target.line;
        int spacePos = 0;
        while (' ' == line.charAt(spacePos)) {
            ++spacePos;
        }
        if (line.charAt(spacePos) == '*') {
            line.setListLevel(1);
            line.setListStart(true);
            line.erase(0, spacePos + 1);
            this.removeWhitespaces(line, ++spacePos);
            return true;
        }
        return false;
    }

    private boolean isDefinitionList(LineParser.TargetLine target, State state) {
        Line line = target.line;
        Line nextLine = target.nextLine;
        if (line.charAt(0) != ' ' && line.charAt(1) != ' ' && line.charAt(0) != '\t' && line.charAt(line.length() - 1) != ':' && line.charAt(line.length() - 2) != ':' && (nextLine.charAt(0) == ' ' && nextLine.charAt(1) == ' ' || nextLine.charAt(0) == '\t')) {
            line.erase();
            return true;
        }
        if (state.inList && (line.charAt(0) == ' ' && line.charAt(1) == ' ' || line.charAt(0) == '\t')) {
            line.setListLevel(1);
            line.setListStart(true);
            this.removeWhitespaces(line, 0);
            return true;
        }
        return false;
    }

    private boolean isDigitList(LineParser.TargetLine target, State state) {
        Line line = target.line;
        Matcher m = DIGIT_PATTERN.matcher(target.line.getText());
        if (m.find()) {
            line.setListLevel(1);
            line.setListStart(true);
            int dotPos = target.line.getText().indexOf(".");
            line.erase(0, ++dotPos);
            this.removeWhitespaces(line, dotPos);
            return true;
        }
        return false;
    }

    private int extractSectionLevel(LineParser.TargetLine target) {
        if (MultiLineProcessUtils.processMultiLineMatch(Character.valueOf('#'), Character.valueOf('#'), target)) {
            return 1;
        }
        if (MultiLineProcessUtils.processMultiLineMatch(Character.valueOf('*'), Character.valueOf('*'), target)) {
            return 1;
        }
        if (MultiLineProcessUtils.processMultiLineMatch(Character.valueOf('='), Character.valueOf('='), target)) {
            return 1;
        }
        if (MultiLineProcessUtils.processMultiLineMatch(null, Character.valueOf('='), target)) {
            return 1;
        }
        if (MultiLineProcessUtils.processMultiLineMatch(Character.valueOf('-'), Character.valueOf('-'), target)) {
            return 1;
        }
        if (MultiLineProcessUtils.processMultiLineMatch(null, Character.valueOf('-'), target)) {
            return 1;
        }
        if (MultiLineProcessUtils.processMultiLineMatch(Character.valueOf('~'), Character.valueOf('~'), target)) {
            return 1;
        }
        if (MultiLineProcessUtils.processMultiLineMatch(null, Character.valueOf('~'), target)) {
            return 1;
        }
        if (MultiLineProcessUtils.processMultiLineMatch(Character.valueOf('^'), Character.valueOf('^'), target)) {
            return 1;
        }
        if (MultiLineProcessUtils.processMultiLineMatch(null, Character.valueOf('^'), target)) {
            return 1;
        }
        return -1;
    }

    private void eraseInlineMarkup(Line line) {
        line.eraseEnclosure(":ref:`", "`", Line.EraseStyle.InlineMarkup);
        line.eraseEnclosure("`", "`:sup:", Line.EraseStyle.InlineMarkup);
        line.eraseEnclosure("`", "`sub:", Line.EraseStyle.InlineMarkup);
        line.eraseEnclosure("*", "*", Line.EraseStyle.InlineMarkup);
        line.eraseEnclosure("**", "**", Line.EraseStyle.InlineMarkup);
        line.eraseEnclosure("`", "`", Line.EraseStyle.InlineMarkup);
        line.eraseEnclosure("``", "``", Line.EraseStyle.InlineMarkup);
        line.eraseEnclosure("`", "`_", Line.EraseStyle.InlineMarkup);
        line.eraseEnclosure("_`", "`", Line.EraseStyle.InlineMarkup);
        line.eraseEnclosure("[", "]_", Line.EraseStyle.All);
        line.eraseEnclosure("|", "|", Line.EraseStyle.InlineMarkup);
    }

    private void removeWhitespaces(Line line, int startPosition) {
        while (Character.isWhitespace(line.charAt(startPosition))) {
            line.erase(startPosition, 1);
            ++startPosition;
        }
    }

    private class State {
        public boolean inTable = false;
        public boolean inBlock = false;
        public boolean inList = false;
        public boolean eraseDirective = true;
        public String type;

        private State() {
        }
    }
}

