/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.parser.review;

import cc.redpen.parser.PreprocessingReader;
import cc.redpen.parser.common.Line;
import cc.redpen.parser.common.LineParser;
import cc.redpen.parser.common.Model;
import cc.redpen.parser.review.ReVIEWLine;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReVIEWParser
extends LineParser {
    private static final Logger LOG = LoggerFactory.getLogger(ReVIEWParser.class);
    static Pattern DIGIT_PATTERN = Pattern.compile("^\\s+[0-9]+\\.");

    @Override
    protected void populateModel(Model model, InputStream io) {
        State state = new State();
        PreprocessingReader reader = this.createReader(io);
        int lineno = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                model.add(new ReVIEWLine(line, ++lineno));
            }
            reader.close();
            model.setPreprocessorRules(reader.getPreprocessorRules());
            model.rewind();
            while (model.isMore()) {
                this.processLine(model.getCurrentLine(), model, state);
                model.getNextLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("Exception when parsing Re:VIEW file", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Re:VIEW parser model (X=erased line,[=block,section-listlevel-lineno,*=list item):\n" + model.toString());
        }
    }

    private void processLine(Line line, Model model, State state) {
        if (line.isErased()) {
            return;
        }
        LineParser.TargetLine target = new LineParser.TargetLine(line, model.getLine(line.getLineNo() - 1), model.getLine(line.getLineNo() + 1));
        if (state.inList && line.getListLevel() == 0) {
            line.setListLevel(target.previousLine.getListLevel());
        }
        if (state.inBlock) {
            if (target.line.startsWith("//}") && target.line.length() == 3) {
                state.inBlock = false;
            }
            line.erase();
        }
        if (!state.inBlock && target.line.startsWith("//")) {
            ReVIEWBlock block = this.parseBlock(line);
            line.erase();
            state.inBlock = block.isOpen;
        }
        if (target.line.startsWith("#@#")) {
            line.erase();
        }
        line.eraseEnclosure("@<list>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<code>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<img>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<table>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<fn>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<chap>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<title>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<chapref>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<bou>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<kw>{", "}", Line.EraseStyle.PreserveAfterLabel);
        line.eraseEnclosure("@<chapter>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<ruby>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<ami>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<b>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<i>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<strong>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<em>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<tt>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<tti>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<ttb>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<u>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<br>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<m>{", "}", Line.EraseStyle.All);
        line.eraseEnclosure("@<icon>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<uchar>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<href>{", "}", Line.EraseStyle.PreserveLabel);
        line.eraseEnclosure("@<column>{", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<raw>{|html|", "}", Line.EraseStyle.All);
        line.eraseEnclosure("@<raw>{|latex|", "}", Line.EraseStyle.Markers);
        line.eraseEnclosure("@<raw>{|idgxml|", "}", Line.EraseStyle.All);
        line.eraseEnclosure("@<raw>{|top|", "}", Line.EraseStyle.All);
        line.eraseEnclosure("#@warn(", ")", Line.EraseStyle.All);
        line.eraseEnclosure("@comment(", ")", Line.EraseStyle.All);
        line.eraseEnclosure("#@mapfile(", ")", Line.EraseStyle.All);
        line.eraseEnclosure("#@maprange(", ")", Line.EraseStyle.All);
        line.eraseEnclosure("#@mapoutput(", ")", Line.EraseStyle.All);
        if (target.line.startsWith("#@end")) {
            line.erase();
        }
        int headerIndent = 0;
        while (line.charAt(headerIndent) == '=') {
            ++headerIndent;
        }
        if (line.charAt(headerIndent) == '[') {
            while (line.charAt(headerIndent) != ']' && line.charAt(headerIndent) != '\u0000') {
                ++headerIndent;
            }
            ++headerIndent;
        }
        if (headerIndent > 0 && line.charAt(headerIndent) == ' ') {
            line.erase(0, headerIndent + 1);
            line.setSectionLevel(headerIndent);
        }
        if (target.line.startsWith("===[/column]")) {
            line.erase();
        }
        if (!state.inBlock && this.isListElement(line, target.nextLine)) {
            state.inList = true;
        }
        if (state.inList && line.length() == 0) {
            state.inList = false;
            line.setListLevel(0);
        }
    }

    private boolean isListElement(Line line, Line nextLine) {
        if (this.isNormalList(line)) {
            return true;
        }
        if (this.isDigitList(line)) {
            return true;
        }
        return this.isLabeledList(line, nextLine);
    }

    private boolean isLabeledList(Line line, Line nextLine) {
        int spacePos = 0;
        while (' ' == line.charAt(spacePos)) {
            ++spacePos;
        }
        if (line.charAt(spacePos) == ':') {
            nextLine.setListLevel(1);
            nextLine.setListStart(true);
            line.erase();
            return true;
        }
        return false;
    }

    private boolean isDigitList(Line line) {
        Matcher m = DIGIT_PATTERN.matcher(line.getText());
        if (m.find()) {
            int dotPos = line.getText().indexOf(".");
            line.setListLevel(1);
            line.setListStart(true);
            line.erase(0, dotPos);
            while (Character.isWhitespace(line.charAt(dotPos))) {
                line.erase(dotPos, 1);
                ++dotPos;
            }
            return true;
        }
        return false;
    }

    private boolean isNormalList(Line line) {
        int pos = 0;
        while (' ' == line.charAt(pos)) {
            ++pos;
        }
        if (pos == 0) {
            return false;
        }
        if ("*".indexOf(line.charAt(pos)) != -1) {
            char listMarker = line.charAt(pos);
            int level = 1;
            ++pos;
            while (line.charAt(pos) == listMarker) {
                ++pos;
                ++level;
            }
            if (Character.isWhitespace(line.charAt(pos))) {
                line.setListLevel(level);
                line.setListStart(true);
                line.erase(0, pos);
                while (Character.isWhitespace(line.charAt(pos))) {
                    line.erase(pos, 1);
                    ++pos;
                }
                return true;
            }
        }
        return false;
    }

    ReVIEWBlock parseBlock(Line line) {
        ReVIEWBlock block = new ReVIEWBlock();
        String text = line.getText();
        int openIdx = text.indexOf("[");
        if (openIdx > 0) {
            block.type = text.substring(2, openIdx);
            int closeIdx = text.indexOf("]");
            while (closeIdx > 0) {
                block.properties.add(text.substring(openIdx + 1, closeIdx));
                openIdx = text.indexOf("[", openIdx + 1);
                closeIdx = text.indexOf("]", closeIdx + 1);
            }
        } else {
            int leftBracePosition = text.indexOf("{");
            block.type = text.substring(2, leftBracePosition > 0 ? leftBracePosition : text.length() - 1);
        }
        if (text.indexOf("{") > 0) {
            block.isOpen = true;
        }
        return block;
    }

    class ReVIEWBlock {
        public String type = "";
        public List<String> properties = new ArrayList<String>();
        public boolean isOpen = false;

        ReVIEWBlock() {
        }
    }

    private class State {
        public boolean inBlock = false;
        public boolean inList = false;
        public boolean eraseBlock = true;
        public String type;

        private State() {
        }
    }
}

