/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.tokenizer;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class TokenElement
implements Serializable {
    private static final long serialVersionUID = -7779529873101010570L;
    private final String surface;
    private final List<String> tags;
    private final int offset;

    public TokenElement(String word, List<String> tagList, int offset) {
        this.surface = word;
        this.tags = Collections.unmodifiableList(tagList);
        this.offset = offset;
    }

    public String getSurface() {
        return this.surface;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenElement that = (TokenElement)o;
        if (this.surface != null ? !this.surface.equals(that.surface) : that.surface != null) {
            return false;
        }
        return !(this.tags != null ? !this.tags.equals(that.tags) : that.tags != null);
    }

    public int hashCode() {
        int result = this.surface != null ? this.surface.hashCode() : 0;
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 64 * result + this.offset;
        return result;
    }

    public String toString() {
        return "TokenElement{surface='" + this.surface + '\'' + ", offset=" + this.offset + ", tags=" + this.tags + '}';
    }
}

