/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.tokenizer;

import cc.redpen.tokenizer.RedPenTokenizer;
import cc.redpen.tokenizer.TokenElement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class WhiteSpaceTokenizer
implements RedPenTokenizer {
    private static final Pattern[] BLACKLIST_TOKEN_PATTERNS = new Pattern[]{Pattern.compile("^[-+#$\u20ac\u00a3\u00a5]?\\d+(\\.\\d+)?[%\u20ac\u00a5\u00a2\u20bd]?$")};
    private static final String DELIMITERS = " \u00a0\t\n\r?!,:;.()\u2014\"";
    private static final String WRAPPED_DELIMITERS = "'";

    @Override
    public List<TokenElement> tokenize(String content) {
        ArrayList<TokenElement> tokens = new ArrayList<TokenElement>();
        String surface = "";
        int offset = 0;
        ArrayList<String> tags = new ArrayList<String>();
        int l = content.length();
        for (int i = 0; i < l; ++i) {
            char ch = content.charAt(i);
            if (DELIMITERS.indexOf(ch) != -1 || this.isWrappedDelimiters(content, i)) {
                if (this.isSuitableToken(surface)) {
                    tokens.add(new TokenElement(surface, tags, offset));
                }
                if (!Character.isWhitespace(ch) && ch != '\u00a0') {
                    tokens.add(new TokenElement(String.valueOf(ch), tags, i));
                }
                surface = "";
                offset = -1;
                continue;
            }
            if (offset < 0) {
                offset = i;
            }
            surface = surface + ch;
        }
        if (this.isSuitableToken(surface)) {
            tokens.add(new TokenElement(surface, tags, offset));
        }
        return tokens;
    }

    private boolean isWrappedDelimiters(String content, int i) {
        Character ch = Character.valueOf(content.charAt(i));
        return WRAPPED_DELIMITERS.indexOf(ch.charValue()) != -1 && (i > 0 && content.charAt(i - 1) == ' ' || i < content.length() - 1 && content.charAt(i + 1) == ' ');
    }

    private boolean isSuitableToken(String surface) {
        if (surface.isEmpty()) {
            return false;
        }
        for (Pattern pattern : BLACKLIST_TOKEN_PATTERNS) {
            if (!pattern.matcher(surface).find()) continue;
            return false;
        }
        return true;
    }
}

