/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.util;

import cc.redpen.RedPenException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryLoader<E> {
    private static final Logger LOG = LoggerFactory.getLogger(DictionaryLoader.class);
    private final Supplier<E> supplier;
    private final BiConsumer<E, String> loader;
    private final Map<String, E> resourceCache = new HashMap<String, E>();
    private final Map<String, E> fileCache = new HashMap<String, E>();
    private final Map<String, Long> fileNameTimestampMap = new HashMap<String, Long>();

    public DictionaryLoader(Supplier<E> supplier, BiConsumer<E, String> loader) {
        this.supplier = supplier;
        this.loader = loader;
    }

    E load(InputStream inputStream) throws IOException {
        E e = this.supplier.get();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            bufferedReader.lines().forEach(line -> this.loader.accept(e, (String)line));
        }
        return e;
    }

    private E loadFromResource(String resourcePath) throws IOException {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);){
            if (inputStream == null) {
                throw new IOException("Failed to load input " + resourcePath);
            }
            E e = this.load(inputStream);
            return e;
        }
    }

    private E loadFromFile(File file) throws IOException {
        return this.load(new FileInputStream(file));
    }

    public E loadCachedFromResource(String path, String dictionaryName) {
        return (E)this.resourceCache.computeIfAbsent(path, e -> {
            try {
                E result = this.loadFromResource(path);
                LOG.info("Succeeded to load " + dictionaryName + ".");
                return result;
            }
            catch (IOException ioe) {
                LOG.error("Failed to load " + dictionaryName + ":" + path + ": " + ioe.getMessage());
                return this.supplier.get();
            }
        });
    }

    public E loadCachedFromFile(File file, String dictionaryName) throws RedPenException {
        String path = file.getAbsolutePath();
        if (!file.exists()) {
            throw new RedPenException("File not found: " + file);
        }
        long currentModified = file.lastModified();
        this.fileNameTimestampMap.computeIfPresent(path, (key, lastModified) -> {
            if (lastModified != currentModified) {
                this.fileCache.remove(key);
                return null;
            }
            return lastModified;
        });
        Object loaded = this.fileCache.computeIfAbsent(path, e -> {
            try {
                E newlyLoaded = this.loadFromFile(file);
                this.fileNameTimestampMap.put(path, file.lastModified());
                return newlyLoaded;
            }
            catch (IOException ioe) {
                LOG.error(ioe.getMessage());
                return null;
            }
        });
        if (loaded == null) {
            throw new RedPenException("Failed to load " + dictionaryName + ":" + path);
        }
        LOG.info("Succeeded to load " + dictionaryName + ".");
        return (E)loaded;
    }
}

