/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.util;

import cc.redpen.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndOfSentenceDetector {
    private List<String> whiteList;
    private Pattern pattern;
    private static final Logger LOG = LoggerFactory.getLogger(EndOfSentenceDetector.class);

    public EndOfSentenceDetector(Pattern pattern) {
        this.pattern = pattern;
        this.whiteList = new ArrayList<String>();
    }

    public EndOfSentenceDetector(Pattern pattern, List<String> whiteList) {
        this.pattern = pattern;
        this.whiteList = whiteList;
    }

    private static boolean checkPosition(int position, String str) {
        return -1 < position && position < str.length() - 1;
    }

    public int getSentenceEndPosition(String str, int startPosition) {
        Set<Integer> nonEndOfSentencePositions = this.extractNonEndOfSentencePositions(str);
        int result = str.length();
        try {
            result = this.getEndPosition(str, startPosition, nonEndOfSentencePositions);
        }
        catch (StackOverflowError e) {
            LOG.error("Catch StackOverflowError parsing :" + str + " from position: " + startPosition);
        }
        return result;
    }

    private int getEndPosition(String str, int offset, Set<Integer> whitePositions) {
        int startPosition = -1;
        int endPosition = -1;
        Matcher matcher = this.pattern.matcher(str);
        boolean matchResult = this.getEndPositionSkippingWhiteList(offset, matcher, whitePositions);
        if (matchResult) {
            startPosition = matcher.start();
            endPosition = matcher.end();
        }
        if (EndOfSentenceDetector.checkPosition(endPosition - 1, str)) {
            if (StringUtils.isBasicLatin(str.charAt(startPosition)) && (' ' == str.charAt(endPosition) || '\n' == str.charAt(endPosition))) {
                return endPosition - 1;
            }
            return this.handleSuccessivePeriods(str, endPosition - 1, whitePositions);
        }
        if (endPosition == str.length()) {
            return endPosition - 1;
        }
        return -1;
    }

    private boolean getEndPositionSkippingWhiteList(int offset, Matcher matcher, Set<Integer> whitePositions) {
        boolean result = matcher.find(offset);
        while (result) {
            int startPosition = matcher.start();
            int endPosition = matcher.end();
            boolean containsWhite = false;
            for (int i = startPosition; i < endPosition; ++i) {
                if (!whitePositions.contains(i)) continue;
                containsWhite = true;
                break;
            }
            if (!containsWhite) break;
            result = this.getEndPositionSkippingWhiteList(endPosition, matcher, whitePositions);
        }
        return result;
    }

    private Set<Integer> extractNonEndOfSentencePositions(String inputString) {
        HashSet<Integer> nonEndOfSentencePositions = new HashSet<Integer>();
        block0: for (String whiteWord : this.whiteList) {
            int offset = 0;
            while (true) {
                int matchStartPosition = inputString.indexOf(whiteWord, offset);
                int matchEndPosition = matchStartPosition + whiteWord.length();
                if (matchStartPosition == -1) continue block0;
                for (int i = matchStartPosition; i < matchEndPosition; ++i) {
                    nonEndOfSentencePositions.add(i);
                }
                offset = matchEndPosition;
            }
        }
        return nonEndOfSentencePositions;
    }

    private int handleSuccessivePeriods(String str, int position, Set<Integer> whitePositions) {
        int nextPosition = position + 1;
        Matcher matcher = this.pattern.matcher(str);
        int matchPosition = -1;
        if (matcher.find(nextPosition)) {
            matchPosition = matcher.start();
        }
        if (this.isNonAlphabetWithoutSucessiveEnd(str, nextPosition, matchPosition) || this.isNonAlphabetEndOfSentenceWithPartialSentence(str, position, matchPosition)) {
            return position;
        }
        if (matchPosition == nextPosition) {
            if (position + 1 == str.length() - 1) {
                return nextPosition;
            }
            return this.getEndPosition(str, nextPosition, whitePositions);
        }
        return this.getEndPosition(str, nextPosition, whitePositions);
    }

    private boolean isNonAlphabetEndOfSentenceWithPartialSentence(String str, int position, int matchPosition) {
        return matchPosition == -1 && !StringUtils.isBasicLatin(str.charAt(position));
    }

    private boolean isNonAlphabetWithoutSucessiveEnd(String str, int nextPosition, int matchPosition) {
        return matchPosition > -1 && !StringUtils.isBasicLatin(str.charAt(matchPosition)) && matchPosition != nextPosition;
    }
}

