/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.util;

import cc.redpen.util.StringUtils;
import java.util.function.Predicate;

public class LanguageDetector {
    public String detectLanguage(String text) {
        boolean hankaku;
        if (!this.has(text, StringUtils::isProbablyJapanese)) {
            return this.has(text, StringUtils::isCyrillic) ? "ru" : "en";
        }
        boolean zenkaku = text.indexOf(12290) >= 0 || text.indexOf(12289) >= 0 || text.indexOf(65281) >= 0 || text.indexOf(65311) >= 0;
        boolean zenkaku2 = text.indexOf(65294) >= 0 || text.indexOf(65292) >= 0;
        boolean bl = hankaku = text.indexOf(46) >= 0 || text.indexOf(44) >= 0 || text.indexOf(33) >= 0 || text.indexOf(63) >= 0;
        return zenkaku ? "ja" : (zenkaku2 ? "ja.zenkaku2" : (hankaku ? "ja.hankaku" : "ja"));
    }

    private boolean has(String text, Predicate<Character> func) {
        char[] chars = text.toCharArray();
        for (int i = 0; i < Math.min(chars.length, 100); ++i) {
            char c = chars[i];
            if (!func.test(Character.valueOf(c))) continue;
            return true;
        }
        return false;
    }
}

