/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.util;

public class LevenshteinDistance {
    public static final int DEFAULT_INSERTION_COST = 1;
    public static final int DEFAULT_DELETION_COST = 1;
    public static final int DEFAULT_SUBSTITUTION_COST = 1;
    private static int INSERTION_COST = 1;
    private static int DELETION_COST = 1;
    private static int SUBSTITUTION_COST = 1;

    private LevenshteinDistance() {
    }

    public static int getInsertionCost() {
        return INSERTION_COST;
    }

    public static synchronized void setInsertionCost(int cost) {
        INSERTION_COST = cost;
    }

    public static int getDeletionCost() {
        return DELETION_COST;
    }

    public static synchronized void setDeletionCost(int cost) {
        DELETION_COST = cost;
    }

    public static int getSubstitutionCost() {
        return SUBSTITUTION_COST;
    }

    public static synchronized void setSubstitutionCost(int cost) {
        SUBSTITUTION_COST = cost;
    }

    public static int getDistance(CharSequence a, CharSequence b) {
        int i;
        if (a == null && b == null) {
            return 0;
        }
        if (a == null && b != null) {
            return b.length() * INSERTION_COST;
        }
        if (a != null && b == null) {
            return a.length() * INSERTION_COST;
        }
        int lengthA = a.length();
        int lengthB = b.length();
        int[][] distance = new int[lengthA + 1][lengthB + 1];
        for (i = 0; i < lengthA + 1; ++i) {
            distance[i][0] = i * DELETION_COST;
        }
        for (int j = 0; j < lengthB + 1; ++j) {
            distance[0][j] = j * INSERTION_COST;
        }
        for (i = 1; i < lengthA + 1; ++i) {
            for (int j = 1; j < lengthB + 1; ++j) {
                distance[i][j] = a.charAt(i - 1) == b.charAt(j - 1) ? distance[i - 1][j - 1] : Math.min(Math.min(distance[i - 1][j] + DELETION_COST, distance[i][j - 1] + INSERTION_COST), distance[i - 1][j - 1] + SUBSTITUTION_COST);
            }
        }
        return distance[lengthA][lengthB];
    }
}

