/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator;

import cc.redpen.RedPenException;
import cc.redpen.util.DictionaryLoader;
import cc.redpen.validator.Validator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public abstract class DictionaryValidator
extends Validator {
    protected DictionaryLoader<Set<String>> loader = WORD_LIST;
    private String dictionaryPrefix;
    private Set<String> dictionary = Collections.emptySet();

    public DictionaryValidator() {
        super("list", new HashSet(), "dict", "");
    }

    public DictionaryValidator(Object ... keyValues) {
        this();
        this.addDefaultProperties(keyValues);
    }

    public DictionaryValidator(String dictionaryPrefix) {
        this();
        this.dictionaryPrefix = dictionaryPrefix;
    }

    public DictionaryValidator(DictionaryLoader<Set<String>> loader, String dictionaryPrefix) {
        this(dictionaryPrefix);
        this.loader = loader;
    }

    @Override
    protected void init() throws RedPenException {
        String confFile;
        if (this.dictionaryPrefix != null) {
            String defaultDictionaryFile = "default-resources/" + this.dictionaryPrefix + "-" + this.getSymbolTable().getLang() + ".dat";
            this.dictionary = this.loader.loadCachedFromResource(defaultDictionaryFile, this.getClass().getSimpleName() + " default dictionary");
        }
        if (StringUtils.isNotEmpty((CharSequence)(confFile = this.getString("dict")))) {
            this.getSet("list").addAll((Collection<String>)this.loader.loadCachedFromFile(this.findFile(confFile), this.getClass().getSimpleName() + " user dictionary"));
        }
    }

    protected boolean inDictionary(String word) {
        Set<String> customDictionary = this.getSet("list");
        return this.dictionary.contains(word) || customDictionary != null && customDictionary.contains(word);
    }

    protected boolean dictionaryExists() {
        Set<String> customDictionary = this.getSet("list");
        return !this.dictionary.isEmpty() || customDictionary != null && !customDictionary.isEmpty();
    }

    protected Stream<String> streamDictionary() {
        return Stream.concat(this.dictionary.stream(), this.getSet("list").stream());
    }
}

