/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator;

import cc.redpen.RedPenException;
import cc.redpen.config.SymbolTable;
import cc.redpen.model.Document;
import cc.redpen.model.Section;
import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.validator.Validator;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptLoader
extends Validator {
    private static final Logger LOG = LoggerFactory.getLogger(JavaScriptLoader.class);
    private final String name;
    private final Invocable invocable;
    private final String message;
    private static final ScriptEngineManager manager = new ScriptEngineManager();
    private static final String[] methodsToBeExposedToJS = new String[]{"getInt", "getFloat", "getString", "getBoolean", "getSet", "getConfigAttribute", "getSymbolTable", "addError", "addErrorWithPosition", "addLocalizedError", "addLocalizedErrorFromToken", "addLocalizedErrorWithPosition"};
    private Map<String, Boolean> functionExistenceMap = new HashMap<String, Boolean>();

    JavaScriptLoader(String name, String script) throws RedPenException {
        this.name = name;
        this.setValidatorName(name);
        ScriptEngine engine = manager.getEngineByName("nashorn");
        try {
            block5: {
                engine.put("redpenToBeBound", this);
                for (String methodToBeExposed : methodsToBeExposedToJS) {
                    engine.eval(String.format("var %s = Function.prototype.bind.call(redpenToBeBound.%s, redpenToBeBound);", methodToBeExposed, methodToBeExposed));
                }
                try {
                    engine.eval("var _JavaScriptValidatorTest = Java.type('cc.redpen.validator.JavaScriptValidatorTest');");
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof ClassNotFoundException) break block5;
                    throw e;
                }
            }
            engine.eval("java = undefined; javax = undefined; Java = undefined; load = undefined; redpenToBeBound = undefined;");
            CompiledScript compiledScript = ((Compilable)((Object)engine)).compile(script);
            compiledScript.eval();
            this.message = (String)engine.get("message");
            this.invocable = (Invocable)((Object)engine);
        }
        catch (ScriptException e) {
            throw new RedPenException(e);
        }
    }

    @Override
    public void preValidate(Sentence sentence) {
        this.call("preValidateSentence", sentence);
    }

    @Override
    public void preValidate(Section section) {
        this.call("preValidateSection", section);
    }

    @Override
    public void validate(Document document) {
        this.call("validateDocument", document);
    }

    @Override
    public void validate(Sentence sentence) {
        this.call("validateSentence", sentence);
    }

    @Override
    public void validate(Section section) {
        this.call("validateSection", section);
    }

    private void call(String functionName, Object ... args) {
        Boolean functionExists = this.functionExistenceMap.getOrDefault(functionName, true);
        if (functionExists.booleanValue()) {
            try {
                this.invocable.invokeFunction(functionName, args);
            }
            catch (ScriptException e) {
                LOG.error("failed to invoke {}", (Object)functionName, (Object)e);
            }
            catch (NoSuchMethodException ignore) {
                this.functionExistenceMap.put(functionName, false);
            }
        }
    }

    @Override
    public int getInt(String name) {
        return super.getInt(name);
    }

    @Override
    public float getFloat(String name) {
        return super.getFloat(name);
    }

    @Override
    public String getString(String name) {
        return super.getString(name);
    }

    @Override
    public boolean getBoolean(String name) {
        return super.getBoolean(name);
    }

    @Override
    public Set<String> getSet(String name) {
        return super.getSet(name);
    }

    @Override
    public Optional<String> getConfigAttribute(String name) {
        return super.getConfigAttribute(name);
    }

    @Override
    public SymbolTable getSymbolTable() {
        return super.getSymbolTable();
    }

    @Override
    public void addError(String message, Sentence sentenceWithError) {
        super.addError(message, sentenceWithError);
    }

    @Override
    Object getOrDefault(String name) {
        Object value = super.getOrDefault(this.name.replaceAll("\\.js$", "") + "-" + name);
        if (value == null) {
            value = super.getOrDefault(name);
        }
        return value;
    }

    @Override
    public void addErrorWithPosition(String message, Sentence sentenceWithError, int start, int end) {
        super.addLocalizedErrorWithPosition(message, sentenceWithError, start, end, new Object[0]);
    }

    @Override
    public void addLocalizedError(Sentence sentenceWithError, Object ... args) {
        super.addLocalizedError(sentenceWithError, args);
    }

    @Override
    public void addLocalizedError(String messageKey, Sentence sentenceWithError, Object ... args) {
        super.addLocalizedError(messageKey, sentenceWithError, args);
    }

    @Override
    public void addLocalizedErrorFromToken(Sentence sentenceWithError, TokenElement token) {
        super.addLocalizedErrorFromToken(sentenceWithError, token);
    }

    @Override
    public void addLocalizedErrorWithPosition(Sentence sentenceWithError, int start, int end, Object ... args) {
        super.addLocalizedErrorWithPosition(sentenceWithError, start, end, args);
    }

    @Override
    protected String getLocalizedErrorMessage(String key, Object ... args) {
        if (this.message != null) {
            return MessageFormat.format(this.message, args);
        }
        return super.getLocalizedErrorMessage(key, args);
    }
}

