/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator;

import cc.redpen.RedPenException;
import cc.redpen.config.Configuration;
import cc.redpen.config.ValidatorConfiguration;
import cc.redpen.model.Document;
import cc.redpen.model.Section;
import cc.redpen.model.Sentence;
import cc.redpen.validator.JavaScriptLoader;
import cc.redpen.validator.ValidationError;
import cc.redpen.validator.Validator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptValidator
extends Validator {
    private static final Logger LOG = LoggerFactory.getLogger(JavaScriptValidator.class);
    final List<JavaScriptLoader> scripts = new ArrayList<JavaScriptLoader>();
    private static final Map<File, String> fileCache = new HashMap<File, String>();
    private static final Map<File, Long> loadTime = new HashMap<File, Long>();
    List<ValidationError> errors;

    public JavaScriptValidator() {
        super("script-path", "js");
    }

    @Override
    protected void init() throws RedPenException {
        try {
            String jsValidatorsPath = this.getString("script-path");
            File jsDirectory = this.findFile(jsValidatorsPath);
            LOG.info("JavaScript validators directory: {}", (Object)jsValidatorsPath);
            File[] jsValidatorFiles = jsDirectory.listFiles();
            if (jsValidatorFiles != null) {
                for (File file : jsValidatorFiles) {
                    if (!file.isFile() || !file.getName().endsWith(".js")) continue;
                    try {
                        JavaScriptLoader valid = new JavaScriptLoader(file.getName(), JavaScriptValidator.loadCached(file));
                        this.scripts.add(valid);
                    }
                    catch (IOException e) {
                        LOG.error("Exception while reading js file", (Throwable)e);
                    }
                }
            }
        }
        catch (RedPenException e) {
            LOG.warn("JavaScript validators directory is missing: {}", (Object)e.toString());
        }
    }

    @Override
    public void preInit(ValidatorConfiguration config, Configuration globalConfig) throws RedPenException {
        super.preInit(config, globalConfig);
        for (JavaScriptLoader js : this.scripts) {
            js.preInit(config, globalConfig);
        }
    }

    static String loadCached(File file) throws IOException {
        Objects.requireNonNull(file);
        Long storedTimestamp = loadTime.get(file);
        if (storedTimestamp != null && storedTimestamp.longValue() == file.lastModified()) {
            return fileCache.get(file);
        }
        String read = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])), Charset.forName("UTF-8"));
        fileCache.put(file, read);
        loadTime.put(file, file.lastModified());
        return read;
    }

    @Override
    public void setErrorList(List<ValidationError> errors) {
        this.errors = errors;
    }

    @Override
    public void preValidate(Sentence sentence) {
        for (JavaScriptLoader js : this.scripts) {
            js.setErrorList(this.errors);
            js.preValidate(sentence);
        }
    }

    @Override
    public void preValidate(Section section) {
        for (JavaScriptLoader js : this.scripts) {
            js.setErrorList(this.errors);
            js.preValidate(section);
        }
    }

    @Override
    public void validate(Document document) {
        for (JavaScriptLoader js : this.scripts) {
            js.setErrorList(this.errors);
            js.validate(document);
        }
    }

    @Override
    public void validate(Sentence sentence) {
        for (JavaScriptLoader js : this.scripts) {
            js.setErrorList(this.errors);
            js.validate(sentence);
        }
    }

    @Override
    public void validate(Section section) {
        for (JavaScriptLoader js : this.scripts) {
            js.setErrorList(this.errors);
            js.validate(section);
        }
    }
}

