/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator;

import cc.redpen.model.Sentence;
import cc.redpen.parser.LineOffset;
import java.io.Serializable;
import java.util.Optional;

public class ValidationError
implements Serializable {
    private static final long serialVersionUID = -7759439419047004667L;
    private final String message;
    private final String validatorName;
    private final Sentence sentence;
    private final LineOffset startPosition;
    private final LineOffset endPosition;

    public ValidationError(String validatorName, String errorMessage, Sentence sentenceWithError) {
        this.message = errorMessage;
        this.validatorName = validatorName;
        this.sentence = sentenceWithError;
        this.startPosition = null;
        this.endPosition = null;
    }

    ValidationError(String validatorName, String errorMessage, Sentence sentenceWithError, int startPosition, int endPosition) {
        this.message = errorMessage;
        this.validatorName = validatorName;
        this.sentence = sentenceWithError;
        this.startPosition = sentenceWithError.getOffset(startPosition).get();
        this.endPosition = sentenceWithError.getOffset(endPosition).get();
    }

    ValidationError(Class validatorClass, String errorMessage, Sentence sentenceWithError, LineOffset startPosition, LineOffset endPosition) {
        this.message = errorMessage;
        this.validatorName = validatorClass.getSimpleName();
        this.sentence = sentenceWithError;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public int getLineNumber() {
        return this.sentence.getLineNumber();
    }

    public String getMessage() {
        return this.message;
    }

    public int getStartColumnNumber() {
        return this.sentence.getStartPositionOffset();
    }

    public Sentence getSentence() {
        return this.sentence;
    }

    public String getValidatorName() {
        if (this.validatorName.endsWith("Validator")) {
            return this.validatorName.substring(0, this.validatorName.length() - "Validator".length());
        }
        return this.validatorName;
    }

    public Optional<LineOffset> getStartPosition() {
        return Optional.ofNullable(this.startPosition);
    }

    public Optional<LineOffset> getEndPosition() {
        return Optional.ofNullable(this.endPosition);
    }

    public String toString() {
        return "ValidationError{message='" + this.message + '\'' + ", validatorName='" + this.validatorName + '\'' + ", sentence=" + this.sentence + ", startPosition=" + this.startPosition + ", endPosition=" + this.endPosition + '}';
    }
}

