/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator;

import cc.redpen.RedPenException;
import cc.redpen.config.Configuration;
import cc.redpen.config.SymbolTable;
import cc.redpen.config.ValidatorConfiguration;
import cc.redpen.model.Document;
import cc.redpen.model.Section;
import cc.redpen.model.Sentence;
import cc.redpen.parser.LineOffset;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.util.DictionaryLoader;
import cc.redpen.util.RuleExtractor;
import cc.redpen.validator.ExpressionRule;
import cc.redpen.validator.ValidationError;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Validator {
    private static final Logger LOG = LoggerFactory.getLogger(Validator.class);
    private static final ResourceBundle.Control fallbackControl = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT);
    private Map<String, Object> defaultProps;
    private ResourceBundle errorMessages = null;
    protected ValidatorConfiguration config;
    protected Configuration globalConfig;
    private Locale locale;
    private String validatorName = this.getClass().getSimpleName();
    private List<ValidationError> errors;
    protected static final DictionaryLoader<Map<String, String>> KEY_VALUE = new DictionaryLoader<Map>(HashMap::new, (map, line) -> {
        String[] result = line.split("\t");
        if (result.length == 2) {
            map.put(result[0], result[1]);
        } else {
            LOG.error("Skip to load line... Invalid line: " + line);
        }
    });
    protected static final DictionaryLoader<Set<ExpressionRule>> RULE = new DictionaryLoader<Set>(HashSet::new, (set, line) -> set.add(RuleExtractor.run(line)));
    protected static final DictionaryLoader<Set<String>> WORD_LIST = new DictionaryLoader<Set>(HashSet::new, Set::add);
    protected static final DictionaryLoader<Set<String>> WORD_LIST_LOWERCASED = new DictionaryLoader<Set>(HashSet::new, (set, line) -> set.add(line.toLowerCase()));

    public Validator() {
        this(new Object[0]);
    }

    public Validator(Object ... keyValues) {
        this.setLocale(Locale.getDefault());
        this.setDefaultProperties(keyValues);
    }

    protected void setDefaultProperties(Object ... keyValues) {
        this.defaultProps = new LinkedHashMap<String, Object>();
        this.addDefaultProperties(keyValues);
    }

    protected void addDefaultProperties(Object ... keyValues) {
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException("Not enough values specified");
        }
        for (int i = 0; i < keyValues.length; i += 2) {
            this.defaultProps.put(keyValues[i].toString(), keyValues[i + 1]);
        }
    }

    public void setErrorList(List<ValidationError> errors) {
        this.errors = errors;
    }

    public void preValidate(Sentence sentence) {
    }

    public void preValidate(Section section) {
    }

    public void validate(Document document) {
    }

    public void validate(Sentence sentence) {
    }

    public void validate(Section section) {
    }

    public List<String> getSupportedLanguages() {
        return Collections.emptyList();
    }

    public void preInit(ValidatorConfiguration config, Configuration globalConfig) throws RedPenException {
        this.config = config;
        this.globalConfig = globalConfig;
        this.init();
    }

    void setLocale(Locale locale) {
        this.locale = locale;
        String packageName = this.getClass().getPackage() != null ? this.getClass().getPackage().getName() : "";
        try {
            this.errorMessages = ResourceBundle.getBundle(packageName + "." + this.getClass().getSimpleName(), locale, fallbackControl);
        }
        catch (MissingResourceException ignore) {
            try {
                this.errorMessages = ResourceBundle.getBundle(packageName + ".error-messages", locale, fallbackControl);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public Map<String, String> getConfigAttributes() {
        return this.config.getProperties();
    }

    protected void init() throws RedPenException {
    }

    public Map<String, Object> getProperties() {
        return this.defaultProps;
    }

    Object getOrDefault(String name) {
        Object value = null;
        if (this.config != null) {
            value = this.config.getProperty(name);
        }
        if (value == null) {
            value = this.defaultProps.get(name);
        }
        return value;
    }

    protected int getInt(String name) {
        Object value = this.getOrDefault(name);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.valueOf((String)value);
    }

    protected float getFloat(String name) {
        Object value = this.getOrDefault(name);
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        return Float.valueOf((String)value).floatValue();
    }

    protected String getString(String name) {
        return this.config.getProperties().getOrDefault(name, (String)this.defaultProps.get(name));
    }

    protected boolean getBoolean(String name) {
        Object value = this.getOrDefault(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf((String)value);
    }

    protected Set<String> getSet(String name) {
        Object value = null;
        if (this.config != null) {
            value = this.config.getProperty(name);
        }
        if (StringUtils.isEmpty((CharSequence)((String)value))) {
            value = this.defaultProps.get(name);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Set) {
            return (Set)value;
        }
        Set<String> newValue = Arrays.stream(((String)value).split(",")).map(String::toLowerCase).collect(Collectors.toSet());
        this.defaultProps.put(name, newValue);
        return newValue;
    }

    protected Map<String, String> getMap(String name) {
        Object value = null;
        if (this.config != null) {
            value = this.config.getProperty(name);
        }
        if (StringUtils.isEmpty((CharSequence)((String)value))) {
            value = this.defaultProps.get(name);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        Map<String, String> newValue = this.parseMap((String)value);
        this.defaultProps.put(name, newValue);
        return newValue;
    }

    private Map<String, String> parseMap(String mapStr) {
        HashMap<String, String> map = new HashMap<String, String>();
        int start = 0;
        int splitter = 0;
        int end = 0;
        boolean found = false;
        for (int i = 0; i < mapStr.length(); ++i) {
            if (mapStr.charAt(i) == '{') {
                start = i + 1;
                continue;
            }
            if (mapStr.charAt(i) == '}') {
                end = i - 1;
                found = true;
                continue;
            }
            if (mapStr.charAt(i) != ',') continue;
            if (!found) {
                splitter = i + 1;
                continue;
            }
            String key = mapStr.substring(start, splitter - 1);
            while (mapStr.charAt(splitter + 1) == ' ') {
                ++splitter;
            }
            String value = mapStr.substring(splitter, end + 1);
            map.put(key, value);
            start = i + 1;
            end = i + 1;
            splitter = i + 1;
            found = false;
        }
        if (splitter > 0 && end < mapStr.length()) {
            String key = mapStr.substring(start, splitter - 1);
            String value = mapStr.substring(splitter, end + 1);
            map.put(key, value);
        }
        return map;
    }

    protected Optional<String> getConfigAttribute(String name) {
        return Optional.ofNullable(this.config.getProperty(name));
    }

    protected void setValidatorName(String validatorName) {
        this.validatorName = validatorName;
    }

    @Deprecated
    protected String getConfigAttribute(String name, String defaultValue) {
        return this.getConfigAttribute(name).orElse(defaultValue);
    }

    @Deprecated
    protected int getConfigAttributeAsInt(String name, int defaultValue) {
        return Integer.parseInt(this.getConfigAttribute(name, Integer.toString(defaultValue)));
    }

    @Deprecated
    protected boolean getConfigAttributeAsBoolean(String name, boolean defaultValue) {
        return Boolean.parseBoolean(this.getConfigAttribute(name, Boolean.toString(defaultValue)));
    }

    @Deprecated
    protected double getConfigAttributeAsDouble(String name, double defaultValue) {
        return Double.parseDouble(this.getConfigAttribute(name, Double.toString(defaultValue)));
    }

    protected SymbolTable getSymbolTable() {
        return this.globalConfig.getSymbolTable();
    }

    protected File findFile(String relativePath) throws RedPenException {
        return this.globalConfig.findFile(relativePath);
    }

    protected void addError(String message, Sentence sentenceWithError) {
        this.errors.add(new ValidationError(this.validatorName, message, sentenceWithError));
    }

    protected void addErrorWithPosition(String message, Sentence sentenceWithError, int start, int end) {
        this.errors.add(new ValidationError(this.validatorName, message, sentenceWithError, start, end));
    }

    protected void addLocalizedError(Sentence sentenceWithError, Object ... args) {
        this.errors.add(new ValidationError(this.validatorName, this.getLocalizedErrorMessage(null, args), sentenceWithError));
    }

    protected void addLocalizedError(String messageKey, Sentence sentenceWithError, Object ... args) {
        this.errors.add(new ValidationError(this.validatorName, this.getLocalizedErrorMessage(messageKey, args), sentenceWithError));
    }

    protected void addLocalizedErrorFromToken(Sentence sentenceWithError, TokenElement token) {
        this.addLocalizedErrorWithPosition(sentenceWithError, token.getOffset(), token.getOffset() + token.getSurface().length(), token.getSurface());
    }

    protected void addLocalizedErrorWithPosition(Sentence sentenceWithError, int start, int end, Object ... args) {
        this.addLocalizedErrorWithPosition(null, sentenceWithError, start, end, args);
    }

    protected void addLocalizedErrorWithPosition(String messageKey, Sentence sentenceWithError, int start, int end, Object ... args) {
        this.errors.add(new ValidationError(this.validatorName, this.getLocalizedErrorMessage(messageKey, args), sentenceWithError, start, end));
    }

    protected String getLocalizedErrorMessage(String key, Object ... args) {
        if (this.errorMessages != null) {
            String suffix = key != null ? "." + key : "";
            MessageFormat fmt = new MessageFormat(this.errorMessages.getString(this.getClass().getSimpleName() + suffix), this.locale);
            return fmt.format(args);
        }
        throw new AssertionError((Object)"message resource not found.");
    }

    protected void addValidationError(Sentence sentenceWithError, Object ... args) {
        this.addLocalizedError(sentenceWithError, args);
    }

    protected void addValidationError(String messageKey, Sentence sentenceWithError, Object ... args) {
        this.addLocalizedError(messageKey, sentenceWithError, args);
    }

    protected void addValidationErrorFromToken(Sentence sentenceWithError, TokenElement token) {
        this.addLocalizedError(sentenceWithError, token);
    }

    protected void addValidationErrorWithPosition(Sentence sentenceWithError, Optional<LineOffset> start, Optional<LineOffset> end, Object ... args) {
        this.errors.add(new ValidationError(this.getClass(), this.getLocalizedErrorMessage(null, args), sentenceWithError, start.get(), end.get()));
    }

    protected void addValidationErrorWithPosition(String messageKey, Sentence sentenceWithError, Optional<LineOffset> start, Optional<LineOffset> end, Object ... args) {
        this.errors.add(new ValidationError(this.getClass(), this.getLocalizedErrorMessage(messageKey, args), sentenceWithError, start.get(), end.get()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.defaultProps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Validator)) {
            return false;
        }
        Validator validator = (Validator)o;
        return Objects.equals(this.getClass(), validator.getClass()) && Objects.equals(this.config, validator.config);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.config);
    }
}

