/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator;

import cc.redpen.RedPenException;
import cc.redpen.config.ValidatorConfiguration;
import cc.redpen.validator.JavaScriptLoader;
import cc.redpen.validator.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorFactory.class);
    private static final String validatorPackage = Validator.class.getPackage().getName();
    private static final List<String> VALIDATOR_PACKAGES = Arrays.asList(validatorPackage, validatorPackage + ".sentence", validatorPackage + ".section");
    static final Map<String, Validator> validators = new LinkedHashMap<String, Validator>();
    private static final Map<String, String> jsValidators = new LinkedHashMap<String, String>();

    static void registerValidator(Class<? extends Validator> clazz) {
        boolean deprecated;
        boolean bl = deprecated = clazz.getAnnotation(Deprecated.class) != null;
        if (deprecated) {
            LOG.warn(clazz.getName() + " is deprecated");
        }
        validators.put(clazz.getSimpleName().replace("Validator", ""), ValidatorFactory.createValidator(clazz));
    }

    public static List<ValidatorConfiguration> getConfigurations(String lang) {
        List<ValidatorConfiguration> configurations = validators.entrySet().stream().filter(e -> {
            List<String> supportedLanguages = ((Validator)e.getValue()).getSupportedLanguages();
            boolean deprecated = ((Validator)e.getValue()).getClass().getAnnotation(Deprecated.class) != null;
            return (supportedLanguages.isEmpty() || supportedLanguages.contains(lang)) && !deprecated;
        }).map(e -> new ValidatorConfiguration((String)e.getKey(), ValidatorFactory.toStrings(((Validator)e.getValue()).getProperties()))).collect(Collectors.toList());
        LinkedHashMap<String, String> emptyMap = new LinkedHashMap<String, String>();
        for (String jsValidator : jsValidators.keySet()) {
            try {
                Validator jsValidatorInstance = ValidatorFactory.getInstance(jsValidator);
                List<String> supportedLanguages = jsValidatorInstance.getSupportedLanguages();
                if (!supportedLanguages.isEmpty() && !supportedLanguages.contains(lang)) continue;
                configurations.add(new ValidatorConfiguration(jsValidator, emptyMap));
            }
            catch (RedPenException redPenException) {}
        }
        return configurations;
    }

    static Map<String, String> toStrings(Map<String, Object> properties) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            if (e.getValue() instanceof Iterable) {
                result.put(e.getKey(), StringUtils.join((Iterable)((Iterable)e.getValue()), (char)','));
                continue;
            }
            result.put(e.getKey(), e.getValue().toString());
        }
        return result;
    }

    public static Validator getInstance(String validatorName) throws RedPenException {
        cc.redpen.config.Configuration conf = cc.redpen.config.Configuration.builder().addValidatorConfig(new ValidatorConfiguration(validatorName)).build();
        return ValidatorFactory.getInstance(conf.getValidatorConfigs().get(0), conf);
    }

    public static Validator getInstance(ValidatorConfiguration config, cc.redpen.config.Configuration globalConfig) throws RedPenException {
        String validatorName = config.getConfigurationName();
        String script = jsValidators.get(validatorName);
        if (script != null) {
            JavaScriptLoader javaScriptValidator = new JavaScriptLoader(validatorName, script);
            javaScriptValidator.preInit(config, globalConfig);
            return javaScriptValidator;
        }
        Validator prototype = validators.get(config.getConfigurationName());
        Class<Object> validatorClass = prototype != null ? prototype.getClass() : ValidatorFactory.loadPlugin(validatorName);
        Validator validator = ValidatorFactory.createValidator(validatorClass);
        validator.preInit(config, globalConfig);
        return validator;
    }

    private static Class<? extends Validator> loadPlugin(String name) throws RedPenException {
        for (String p : VALIDATOR_PACKAGES) {
            try {
                Class<?> validatorClass = Class.forName(p + "." + name + "Validator");
                ValidatorFactory.registerValidator(validatorClass);
                return validatorClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new RedPenException("There is no such validator: " + name);
    }

    private static Validator createValidator(Class<? extends Validator> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Cannot create instance of " + clazz + " using default constructor");
        }
    }

    static {
        Reflections reflections = new Reflections("cc.redpen.validator", new Scanner[0]);
        reflections.getSubTypesOf(Validator.class).stream().filter(validator -> !Modifier.isAbstract(validator.getModifiers())).forEach(validator -> {
            try {
                ValidatorFactory.registerValidator(validator);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        });
        Reflections jsReflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls(ClasspathHelper.forPackage((String)"cc.redpen.validator", (ClassLoader[])new ClassLoader[0])));
        jsReflections.getResources(Pattern.compile(".*js")).forEach(e -> {
            InputStream inputStream = ValidatorFactory.class.getResourceAsStream("/" + e);
            try (InputStreamReader isr = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
                 BufferedReader br = new BufferedReader(isr);){
                String str;
                StringBuilder sb = new StringBuilder(1024);
                while ((str = br.readLine()) != null) {
                    sb.append(str);
                }
                String validatorName = e.replaceFirst(".*/", "").replaceFirst("\\.js$", "");
                jsValidators.put(validatorName, sb.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

