/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.document;

import cc.redpen.model.Document;
import cc.redpen.model.Paragraph;
import cc.redpen.model.Sentence;
import cc.redpen.validator.Validator;
import java.util.HashMap;
import java.util.Map;

public class FrequentSentenceStartValidator
extends Validator {
    private Map<String, Integer> sentenceStartHistogram = new HashMap<String, Integer>();

    public FrequentSentenceStartValidator() {
        super("leading_word_limit", 3, "percentage_threshold", 25, "min_sentence_count", 5);
    }

    private void processSentence(Sentence sentence) {
        if (sentence.getTokens().size() > this.getInt("leading_word_limit")) {
            String leadingPhrase = "";
            for (int i = 0; i < this.getInt("leading_word_limit"); ++i) {
                leadingPhrase = leadingPhrase + (leadingPhrase.isEmpty() ? "" : " ") + sentence.getTokens().get(i).getSurface();
                Integer count = this.sentenceStartHistogram.get(leadingPhrase);
                if (this.sentenceStartHistogram.get(leadingPhrase) == null) {
                    count = 0;
                }
                this.sentenceStartHistogram.put(leadingPhrase, count + 1);
            }
        }
    }

    @Override
    public void validate(Document document) {
        Sentence lastSentence = null;
        int sentenceCount = 0;
        for (int i = 0; i < document.size(); ++i) {
            for (Paragraph para : document.getSection(i).getParagraphs()) {
                for (Sentence sentence : para.getSentences()) {
                    this.processSentence(sentence);
                    ++sentenceCount;
                    lastSentence = sentence;
                }
            }
        }
        if (sentenceCount >= this.getInt("min_sentence_count")) {
            for (String start : this.sentenceStartHistogram.keySet()) {
                int count = this.sentenceStartHistogram.get(start);
                int percentage = (int)(100.0 * (double)count / (double)this.sentenceStartHistogram.size());
                if (percentage <= this.getInt("percentage_threshold")) continue;
                this.addLocalizedError("SentenceStartTooFrequent", lastSentence, percentage, start);
            }
        }
    }
}

