/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.document;

import cc.redpen.RedPenException;
import cc.redpen.model.Document;
import cc.redpen.model.Paragraph;
import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.validator.sentence.SpellingDictionaryValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class UnexpandedAcronymValidator
extends SpellingDictionaryValidator {
    private Set<String> acronymJoiningWords = new HashSet<String>();
    private Set<String> expandedAcronyms = new HashSet<String>();
    private Set<String> contractedAcronyms = new HashSet<String>();

    public UnexpandedAcronymValidator() {
        this.setDefaultProperties("min_acronym_length", 3);
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.ENGLISH.getLanguage());
    }

    @Override
    protected void init() throws RedPenException {
        super.init();
        this.acronymJoiningWords.add("of");
        this.acronymJoiningWords.add("the");
        this.acronymJoiningWords.add("for");
        this.acronymJoiningWords.add("in");
        this.acronymJoiningWords.add("and");
        this.acronymJoiningWords.add("&");
    }

    private void processSentence(Sentence sentence) {
        ArrayList<String> sequence = new ArrayList<String>();
        for (TokenElement token : sentence.getTokens()) {
            String word = token.getSurface();
            if (word.trim().isEmpty()) continue;
            int minAcronymLength = this.getInt("min_acronym_length");
            if (this.isAllCapitals(word)) {
                if (word.length() < minAcronymLength || this.inDictionary(word) || this.inDictionary(word.toLowerCase())) continue;
                this.contractedAcronyms.add(word);
                continue;
            }
            if (this.isCapitalized(word)) {
                sequence.add(word);
                continue;
            }
            if (this.acronymJoiningWords.contains(word) || sequence.isEmpty()) continue;
            String acronym = "";
            for (String s : sequence) {
                acronym = acronym + s.charAt(0);
            }
            if (acronym.length() >= minAcronymLength) {
                this.expandedAcronyms.add(acronym);
                if (acronym.length() >= minAcronymLength + 1) {
                    this.expandedAcronyms.add(acronym.substring(1));
                }
            }
            sequence.clear();
        }
    }

    private boolean isAllCapitals(String word) {
        if (word.length() > 1) {
            for (int i = 0; i < word.length(); ++i) {
                if (Character.isAlphabetic(word.charAt(i)) && !Character.isLowerCase(word.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isCapitalized(String word) {
        if (!word.isEmpty() && Character.isAlphabetic(word.charAt(0)) && Character.isUpperCase(word.charAt(0))) {
            if (word.length() == 1) {
                return true;
            }
            int lowerCaseCount = 0;
            for (int i = 1; i < word.length(); ++i) {
                if (!Character.isAlphabetic(word.charAt(i)) || !Character.isLowerCase(word.charAt(i))) continue;
                ++lowerCaseCount;
            }
            return lowerCaseCount > 0;
        }
        return false;
    }

    @Override
    public void validate(Document document) {
        Sentence lastSentence = null;
        for (int i = 0; i < document.size(); ++i) {
            for (Paragraph para : document.getSection(i).getParagraphs()) {
                for (Sentence sentence : para.getSentences()) {
                    this.processSentence(sentence);
                    lastSentence = sentence;
                }
            }
        }
        for (String acronym : this.contractedAcronyms) {
            if (this.expandedAcronyms.contains(acronym)) continue;
            this.addLocalizedError("UnexpandedAcronym", lastSentence, acronym);
        }
    }
}

