/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.section;

import cc.redpen.model.Paragraph;
import cc.redpen.model.Section;
import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.validator.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class DuplicatedSectionValidator
extends Validator {
    private List<SectionVector> sectionVectors = new ArrayList<SectionVector>();

    public DuplicatedSectionValidator() {
        super("threshold", Float.valueOf(0.9f));
    }

    @Override
    public void preValidate(Section section) {
        Map<String, Integer> sectionVector = this.extractWordFrequency(section);
        this.sectionVectors.add(new SectionVector(section.getHeaderContent(0), sectionVector));
    }

    private Map<String, Integer> extractWordFrequency(Section section) {
        HashMap<String, Integer> sectionVector = new HashMap<String, Integer>();
        for (Paragraph paragraph : section.getParagraphs()) {
            for (Sentence sentence : paragraph.getSentences()) {
                this.addWords(sectionVector, sentence);
            }
        }
        for (Sentence headerSentence : section.getHeaderContents()) {
            this.addWords(sectionVector, headerSentence);
        }
        return sectionVector;
    }

    @Override
    public void validate(Section section) {
        Map<String, Integer> targetVector = this.extractWordFrequency(section);
        for (SectionVector sectionVector : this.sectionVectors) {
            Map<String, Integer> candidateVector = sectionVector.sectionVector;
            if (sectionVector.header == section.getHeaderContent(0) || !(this.calcCosine(targetVector, candidateVector) > (double)this.getFloat("threshold"))) continue;
            Optional<Sentence> header = Optional.ofNullable(section.getHeaderContent(0));
            if (section.getNumberOfParagraphs() == 0 || sectionVector.header == null) continue;
            this.addLocalizedError(header.orElse(section.getParagraph(0).getSentence(0)), sectionVector.header.getLineNumber());
        }
    }

    private double calcCosine(Map<String, Integer> targetVector, Map<String, Integer> argumentVector) {
        int innerProduct = 0;
        int targetVecLen = this.calcLength(targetVector);
        int argumentVecLen = this.calcLength(argumentVector);
        if (targetVecLen == 0 || argumentVecLen == 0) {
            return 0.0;
        }
        for (String word : targetVector.keySet()) {
            if (!argumentVector.containsKey(word)) continue;
            innerProduct += targetVector.get(word) * argumentVector.get(word);
        }
        return (double)innerProduct / (Math.sqrt(targetVecLen) * Math.sqrt(argumentVecLen));
    }

    private int calcLength(Map<String, Integer> targetVector) {
        int length = 0;
        for (String word : targetVector.keySet()) {
            length += targetVector.get(word) * targetVector.get(word);
        }
        return length;
    }

    private void addWords(Map<String, Integer> sectionVector, Sentence sentence) {
        for (TokenElement token : sentence.getTokens()) {
            String surface = token.getSurface();
            if (!sectionVector.containsKey(surface)) {
                sectionVector.put(surface, 0);
            }
            Integer currentNum = sectionVector.get(surface);
            currentNum = currentNum + 1;
            sectionVector.put(surface, currentNum);
        }
    }

    class SectionVector {
        public final Sentence header;
        public final Map<String, Integer> sectionVector;

        public SectionVector(Sentence header, Map<String, Integer> vector) {
            this.header = header;
            this.sectionVector = vector;
        }

        public String toString() {
            return "SectionVector{header=" + this.header + ", sectionVector=" + this.sectionVector + '}';
        }
    }
}

